/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.properties;

import com.azure.spring.cloud.config.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.config.properties.AppConfigurationStoreSelects;
import com.azure.spring.cloud.config.properties.FeatureFlagStore;
import com.azure.spring.cloud.config.resource.Connection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.util.StringUtils;

public final class ConfigStore {
    private static final String DEFAULT_KEYS = "/application/";
    private String endpoint;
    private String connectionString;
    private List<AppConfigurationStoreSelects> selects = new ArrayList<AppConfigurationStoreSelects>();
    private boolean failFast = true;
    private FeatureFlagStore featureFlags = new FeatureFlagStore();
    private boolean enabled = true;
    private AppConfigurationStoreMonitoring monitoring = new AppConfigurationStoreMonitoring();

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<AppConfigurationStoreSelects> getSelects() {
        return this.selects;
    }

    public void setSelects(List<AppConfigurationStoreSelects> selects) {
        this.selects = selects;
    }

    public AppConfigurationStoreMonitoring getMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(AppConfigurationStoreMonitoring monitoring) {
        this.monitoring = monitoring;
    }

    public FeatureFlagStore getFeatureFlags() {
        return this.featureFlags;
    }

    public void setFeatureFlags(FeatureFlagStore featureFlags) {
        this.featureFlags = featureFlags;
    }

    @PostConstruct
    public void validateAndInit() {
        if (this.selects.isEmpty()) {
            this.selects.add(new AppConfigurationStoreSelects().setKeyFilter(DEFAULT_KEYS));
        }
        for (AppConfigurationStoreSelects selectedKeys : this.selects) {
            selectedKeys.validateAndInit();
        }
        if (StringUtils.hasText((String)this.connectionString)) {
            String endpoint = new Connection(this.connectionString).getEndpoint();
            try {
                new URI(endpoint);
                this.endpoint = endpoint;
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Endpoint in connection string is not a valid URI.", e);
            }
        }
        this.monitoring.validateAndInit();
    }
}

