// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.tables.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The status of the secondary location.
 */
public final class TableServiceGeoReplicationStatus extends ExpandableStringEnum<TableServiceGeoReplicationStatus> {
    /**
     * Static value live for TableServiceGeoReplicationStatus.
     */
    public static final TableServiceGeoReplicationStatus LIVE = fromString("live");

    /**
     * Static value bootstrap for TableServiceGeoReplicationStatus.
     */
    public static final TableServiceGeoReplicationStatus BOOTSTRAP = fromString("bootstrap");

    /**
     * Static value unavailable for TableServiceGeoReplicationStatus.
     */
    public static final TableServiceGeoReplicationStatus UNAVAILABLE = fromString("unavailable");

    /**
     * Creates a new instance of TableServiceGeoReplicationStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public TableServiceGeoReplicationStatus() {
    }

    /**
     * Creates or finds a TableServiceGeoReplicationStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding TableServiceGeoReplicationStatus.
     */
    public static TableServiceGeoReplicationStatus fromString(String name) {
        return fromString(name, TableServiceGeoReplicationStatus.class);
    }

    /**
     * Gets known TableServiceGeoReplicationStatus values.
     * 
     * @return known TableServiceGeoReplicationStatus values.
     */
    public static Collection<TableServiceGeoReplicationStatus> values() {
        return values(TableServiceGeoReplicationStatus.class);
    }
}
