/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.implementation.Conditions;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingDeserializationHelper;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagFilter;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class FeatureFlagConfigurationSetting
extends ConfigurationSetting {
    private static final ClientLogger LOGGER = new ClientLogger(FeatureFlagConfigurationSetting.class);
    private static final String FEATURE_FLAG_CONTENT_TYPE = "application/vnd.microsoft.appconfig.ff+json;charset=utf-8";
    public static final String KEY_PREFIX = ".appconfig.featureflag/";
    private String featureId;
    private boolean isEnabled;
    private String description;
    private String displayName;
    private List<FeatureFlagFilter> clientFilters;
    private boolean isValidFeatureFlagValue = true;
    private final Map<String, Object> parsedProperties = new LinkedHashMap<String, Object>(5);
    private final List<String> requiredJsonProperties = Arrays.asList("id", "enabled", "conditions");
    private final List<String> requiredOrOptionalJsonProperties = Arrays.asList("id", "description", "display_name", "enabled", "conditions");

    public FeatureFlagConfigurationSetting(String featureId, boolean isEnabled) {
        this.featureId = featureId;
        this.isEnabled = isEnabled;
        super.setKey(KEY_PREFIX + featureId);
        super.setContentType(FEATURE_FLAG_CONTENT_TYPE);
    }

    @Override
    public String getValue() {
        String newValue = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            JsonWriter writer = JsonProviders.createWriter((OutputStream)outputStream);
            LinkedHashSet<String> knownProperties = new LinkedHashSet<String>(this.requiredOrOptionalJsonProperties);
            writer.writeStartObject();
            for (Map.Entry<String, Object> entry : this.parsedProperties.entrySet()) {
                String name = entry.getKey();
                Object jsonValue = entry.getValue();
                try {
                    if (this.tryWriteKnownProperty(name, jsonValue, writer, true)) {
                        knownProperties.remove(name);
                        continue;
                    }
                    writer.writeUntypedField(name, jsonValue);
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError(new RuntimeException(e));
                }
            }
            for (String propertyName : knownProperties) {
                this.tryWriteKnownProperty(propertyName, null, writer, false);
            }
            writer.writeEndObject();
            writer.flush();
            newValue = outputStream.toString(StandardCharsets.UTF_8.name());
            outputStream.close();
        }
        catch (IOException exception) {
            LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Can't parse Feature Flag configuration setting value.", exception));
        }
        super.setValue(newValue);
        return newValue;
    }

    @Override
    public FeatureFlagConfigurationSetting setKey(String key) {
        if (key != null && !key.startsWith(KEY_PREFIX)) {
            super.setKey(KEY_PREFIX + key);
        } else {
            super.setKey(key);
        }
        return this;
    }

    @Override
    public FeatureFlagConfigurationSetting setValue(String value) {
        this.tryParseValue(value);
        this.isValidFeatureFlagValue = true;
        super.setValue(value);
        return this;
    }

    @Override
    public FeatureFlagConfigurationSetting setLabel(String label) {
        super.setLabel(label);
        return this;
    }

    @Override
    public FeatureFlagConfigurationSetting setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    @Override
    public FeatureFlagConfigurationSetting setETag(String etag) {
        super.setETag(etag);
        return this;
    }

    @Override
    public FeatureFlagConfigurationSetting setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    public String getFeatureId() {
        this.checkValid();
        return this.featureId;
    }

    public FeatureFlagConfigurationSetting setFeatureId(String featureId) {
        this.checkValid();
        this.featureId = featureId;
        super.setKey(KEY_PREFIX + featureId);
        return this;
    }

    public boolean isEnabled() {
        this.checkValid();
        return this.isEnabled;
    }

    public FeatureFlagConfigurationSetting setEnabled(boolean isEnabled) {
        this.checkValid();
        this.isEnabled = isEnabled;
        return this;
    }

    public String getDescription() {
        this.checkValid();
        return this.description;
    }

    public FeatureFlagConfigurationSetting setDescription(String description) {
        this.checkValid();
        this.description = description;
        return this;
    }

    public String getDisplayName() {
        this.checkValid();
        return this.displayName;
    }

    public FeatureFlagConfigurationSetting setDisplayName(String displayName) {
        this.checkValid();
        this.displayName = displayName;
        return this;
    }

    public List<FeatureFlagFilter> getClientFilters() {
        this.checkValid();
        if (this.clientFilters == null) {
            this.clientFilters = new ArrayList<FeatureFlagFilter>();
        }
        return this.clientFilters;
    }

    public FeatureFlagConfigurationSetting setClientFilters(List<FeatureFlagFilter> clientFilters) {
        this.checkValid();
        this.clientFilters = clientFilters;
        return this;
    }

    public FeatureFlagConfigurationSetting addClientFilter(FeatureFlagFilter clientFilter) {
        this.checkValid();
        if (this.clientFilters == null) {
            this.clientFilters = new ArrayList<FeatureFlagFilter>();
        }
        this.clientFilters.add(clientFilter);
        return this;
    }

    private void checkValid() {
        if (!this.isValidFeatureFlagValue) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The content of the " + super.getValue() + " property do not represent a valid feature flag configuration setting."));
        }
    }

    private boolean tryWriteKnownProperty(String propertyName, Object propertyValue, JsonWriter writer, boolean includeOptionalWhenNull) throws IOException {
        switch (propertyName) {
            case "id": {
                writer.writeStringField("id", this.featureId);
                break;
            }
            case "description": {
                if (!includeOptionalWhenNull && this.description == null) break;
                writer.writeStringField("description", this.description);
                break;
            }
            case "display_name": {
                if (!includeOptionalWhenNull && this.displayName == null) break;
                writer.writeStringField("display_name", this.displayName);
                break;
            }
            case "enabled": {
                writer.writeBooleanField("enabled", this.isEnabled);
                break;
            }
            case "conditions": {
                this.tryWriteConditions(propertyValue, writer);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void tryWriteConditions(Object propertyValue, JsonWriter writer) throws IOException {
        writer.writeStartObject("conditions");
        if (propertyValue != null && propertyValue instanceof Conditions) {
            Conditions propertyValueClone = (Conditions)propertyValue;
            for (Map.Entry<String, Object> entry : propertyValueClone.getUnknownConditions().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                writer.writeUntypedField(key, value);
            }
        }
        writer.writeArrayField("client_filters", this.clientFilters, (jsonWriter, filter) -> {
            jsonWriter.writeStartObject();
            jsonWriter.writeStringField("name", filter.getName());
            jsonWriter.writeMapField("parameters", filter.getParameters(), JsonWriter::writeUntyped);
            jsonWriter.writeEndObject();
        });
        writer.writeEndObject();
    }

    private void tryParseValue(String value) {
        this.parsedProperties.clear();
        try (JsonReader jsonReader = JsonProviders.createReader((String)value);){
            jsonReader.readObject(reader -> {
                LinkedHashSet<String> requiredPropertiesCopy = new LinkedHashSet<String>(this.requiredJsonProperties);
                String featureIdCopy = this.featureId;
                String descriptionCopy = this.description;
                String displayNameCopy = this.displayName;
                boolean isEnabledCopy = this.isEnabled;
                List<FeatureFlagFilter> featureFlagFiltersCopy = this.clientFilters;
                while (reader.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = reader.getFieldName();
                    reader.nextToken();
                    if ("id".equals(fieldName)) {
                        String id;
                        featureIdCopy = id = reader.getString();
                        this.parsedProperties.put("id", id);
                    } else if ("description".equals(fieldName)) {
                        String description;
                        descriptionCopy = description = reader.getString();
                        this.parsedProperties.put("description", description);
                    } else if ("display_name".equals(fieldName)) {
                        String displayName;
                        displayNameCopy = displayName = reader.getString();
                        this.parsedProperties.put("display_name", displayName);
                    } else if ("enabled".equals(fieldName)) {
                        boolean isEnabled;
                        isEnabledCopy = isEnabled = reader.getBoolean();
                        this.parsedProperties.put("enabled", isEnabled);
                    } else if ("conditions".equals(fieldName)) {
                        Conditions conditions = ConfigurationSettingDeserializationHelper.readConditions(reader);
                        if (conditions != null) {
                            List<FeatureFlagFilter> featureFlagFilters = conditions.getFeatureFlagFilters();
                            featureFlagFiltersCopy = featureFlagFilters;
                            this.parsedProperties.put("conditions", conditions);
                        }
                    } else {
                        this.parsedProperties.put(fieldName, reader.readUntyped());
                    }
                    requiredPropertiesCopy.remove(fieldName);
                }
                this.featureId = featureIdCopy;
                this.description = descriptionCopy;
                this.displayName = displayNameCopy;
                this.isEnabled = isEnabledCopy;
                this.clientFilters = featureFlagFiltersCopy;
                return requiredPropertiesCopy.isEmpty();
            });
        }
        catch (IOException e) {
            this.isValidFeatureFlagValue = false;
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(e));
        }
    }
}

