/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai;

import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.implementation.CompletionsUtils;
import com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=OpenAIClientBuilder.class, isAsync=true)
public final class OpenAIAsyncClient {
    private final OpenAIClientImpl serviceClient;
    private final NonAzureOpenAIClientImpl openAIServiceClient;

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEmbeddingsWithResponse(String deploymentId, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getEmbeddingsWithResponseAsync(deploymentId, embeddingsOptions, requestOptions) : this.serviceClient.getEmbeddingsWithResponseAsync(deploymentId, embeddingsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCompletionsWithResponse(String deploymentId, BinaryData completionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getCompletionsWithResponseAsync(deploymentId, completionsOptions, requestOptions) : this.serviceClient.getCompletionsWithResponseAsync(deploymentId, completionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getChatCompletionsWithResponse(String deploymentId, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getChatCompletionsWithResponseAsync(deploymentId, chatCompletionsOptions, requestOptions) : this.serviceClient.getChatCompletionsWithResponseAsync(deploymentId, chatCompletionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Embeddings> getEmbeddings(String deploymentId, EmbeddingsOptions embeddingsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getEmbeddingsWithResponse(deploymentId, BinaryData.fromObject((Object)embeddingsOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Embeddings)protocolMethodData.toObject(Embeddings.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Completions> getCompletions(String deploymentId, CompletionsOptions completionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getCompletionsWithResponse(deploymentId, BinaryData.fromObject((Object)completionsOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Completions)protocolMethodData.toObject(Completions.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Completions> getCompletions(String deploymentId, String prompt) {
        return this.getCompletions(deploymentId, CompletionsUtils.defaultCompletionsOptions(prompt));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<Completions> getCompletionsStream(String deploymentId, CompletionsOptions completionsOptions) {
        completionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        BinaryData requestBody = BinaryData.fromObject((Object)completionsOptions);
        Flux responseStream = this.getCompletionsWithResponse(deploymentId, requestBody, requestOptions).flatMapMany(response -> ((BinaryData)response.getValue()).toFluxByteBuffer());
        OpenAIServerSentEvents<Completions> completionsStream = new OpenAIServerSentEvents<Completions>((Flux<ByteBuffer>)responseStream, Completions.class);
        return completionsStream.getEvents();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ChatCompletions> getChatCompletions(String deploymentId, ChatCompletionsOptions chatCompletionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getChatCompletionsWithResponse(deploymentId, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ChatCompletions)protocolMethodData.toObject(ChatCompletions.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<ChatCompletions> getChatCompletionsStream(String deploymentId, ChatCompletionsOptions chatCompletionsOptions) {
        chatCompletionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = this.getChatCompletionsWithResponse(deploymentId, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).flatMapMany(response -> ((BinaryData)response.getValue()).toFluxByteBuffer());
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream = new OpenAIServerSentEvents<ChatCompletions>((Flux<ByteBuffer>)responseStream, ChatCompletions.class);
        return chatCompletionsStream.getEvents();
    }

    OpenAIAsyncClient(OpenAIClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.openAIServiceClient = null;
    }

    OpenAIAsyncClient(NonAzureOpenAIClientImpl serviceClient) {
        this.serviceClient = null;
        this.openAIServiceClient = serviceClient;
    }
}

