/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.MessageProducerSession;
import com.atomikos.jms.TopicConnectionFactoryBean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Topic;

public class TopicPublisherSession
extends MessageProducerSession {
    public Topic getTopic() {
        return (Topic)this.getDestination();
    }

    public void setTopic(Topic topic) {
        this.setDestination((Destination)topic);
    }

    public void setReplyToTopic(Topic topic) {
        this.setReplyToDestination((Destination)topic);
    }

    public Topic getReplyToTopic() {
        Topic ret = null;
        Destination dest = this.getReplyToDestination();
        if (dest instanceof Topic) {
            ret = (Topic)dest;
        }
        return ret;
    }

    public void setTopicConnectionFactoryBean(TopicConnectionFactoryBean bean) {
        this.setAbstractConnectionFactoryBean(bean);
    }

    public TopicConnectionFactoryBean getTopicConnectionFactoryBean() {
        return (TopicConnectionFactoryBean)this.getAbstractConnectionFactoryBean();
    }

    protected String getDestinationName() {
        String ret = null;
        Topic t = this.getTopic();
        if (t != null) {
            try {
                ret = t.getTopicName();
            }
            catch (JMSException e) {
                Configuration.logDebug((String)"TopicPublisherSession: error retrieving topic name", (Throwable)e);
            }
        }
        return ret;
    }

    protected String getReplyToDestinationName() {
        String ret = null;
        Topic t = this.getReplyToTopic();
        if (t != null) {
            try {
                ret = t.getTopicName();
            }
            catch (JMSException e) {
                Configuration.logDebug((String)"TopicPublisherSession: error retrieving topic name", (Throwable)e);
            }
        }
        return ret;
    }
}

