/*
 * Decompiled with CFR 0.152.
 */
package com.arturmkrtchyan.kafka;

import com.arturmkrtchyan.kafka.KafkaFileSystemHelper;
import com.arturmkrtchyan.kafka.KafkaPluginException;
import com.arturmkrtchyan.kafka.util.ApacheMirrorLocator;
import com.arturmkrtchyan.kafka.util.ApacheProjectDownloader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class KafkaDownloader {
    public void download(Path localBasePath, String scalaVersion, String kafkaVersion) throws KafkaPluginException {
        ApacheProjectDownloader apacheProjectDownloader = new ApacheProjectDownloader();
        ApacheMirrorLocator apacheMirrorLocator = new ApacheMirrorLocator();
        String mirrorUrl = apacheMirrorLocator.locate();
        String artifactName = KafkaFileSystemHelper.artifactName(scalaVersion, kafkaVersion);
        String artifactUrl = this.artifactUrl(mirrorUrl, kafkaVersion, artifactName);
        try {
            apacheProjectDownloader.download(artifactUrl, artifactName, localBasePath);
        }
        catch (IOException | RuntimeException e) {
            throw new KafkaPluginException(String.format("Unable to download %s from %s", artifactName, artifactUrl), e);
        }
    }

    public boolean isDownloaded(Path kafkaFile) {
        return Files.exists(kafkaFile, new LinkOption[0]);
    }

    protected String artifactUrl(String mirrorUrl, String kafkaVersion, String artifactName) {
        return String.format("%skafka/%s/%s", mirrorUrl, kafkaVersion, artifactName);
    }
}

