/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoveryreadiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.route53recoveryreadiness.model.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateResourceSetResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String resourceSetArn;
    private String resourceSetName;
    private String resourceSetType;
    private List<Resource> resources;
    private Map<String, String> tags;

    public void setResourceSetArn(String resourceSetArn) {
        this.resourceSetArn = resourceSetArn;
    }

    public String getResourceSetArn() {
        return this.resourceSetArn;
    }

    public UpdateResourceSetResult withResourceSetArn(String resourceSetArn) {
        this.setResourceSetArn(resourceSetArn);
        return this;
    }

    public void setResourceSetName(String resourceSetName) {
        this.resourceSetName = resourceSetName;
    }

    public String getResourceSetName() {
        return this.resourceSetName;
    }

    public UpdateResourceSetResult withResourceSetName(String resourceSetName) {
        this.setResourceSetName(resourceSetName);
        return this;
    }

    public void setResourceSetType(String resourceSetType) {
        this.resourceSetType = resourceSetType;
    }

    public String getResourceSetType() {
        return this.resourceSetType;
    }

    public UpdateResourceSetResult withResourceSetType(String resourceSetType) {
        this.setResourceSetType(resourceSetType);
        return this;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<Resource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<Resource>(resources);
    }

    public UpdateResourceSetResult withResources(Resource ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<Resource>(resources.length));
        }
        for (Resource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public UpdateResourceSetResult withResources(Collection<Resource> resources) {
        this.setResources(resources);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public UpdateResourceSetResult withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public UpdateResourceSetResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public UpdateResourceSetResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceSetArn() != null) {
            sb.append("ResourceSetArn: ").append(this.getResourceSetArn()).append(",");
        }
        if (this.getResourceSetName() != null) {
            sb.append("ResourceSetName: ").append(this.getResourceSetName()).append(",");
        }
        if (this.getResourceSetType() != null) {
            sb.append("ResourceSetType: ").append(this.getResourceSetType()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceSetResult)) {
            return false;
        }
        UpdateResourceSetResult other = (UpdateResourceSetResult)obj;
        if (other.getResourceSetArn() == null ^ this.getResourceSetArn() == null) {
            return false;
        }
        if (other.getResourceSetArn() != null && !other.getResourceSetArn().equals(this.getResourceSetArn())) {
            return false;
        }
        if (other.getResourceSetName() == null ^ this.getResourceSetName() == null) {
            return false;
        }
        if (other.getResourceSetName() != null && !other.getResourceSetName().equals(this.getResourceSetName())) {
            return false;
        }
        if (other.getResourceSetType() == null ^ this.getResourceSetType() == null) {
            return false;
        }
        if (other.getResourceSetType() != null && !other.getResourceSetType().equals(this.getResourceSetType())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceSetArn() == null ? 0 : this.getResourceSetArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourceSetName() == null ? 0 : this.getResourceSetName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceSetType() == null ? 0 : this.getResourceSetType().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public UpdateResourceSetResult clone() {
        try {
            return (UpdateResourceSetResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

