/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.route53profiles.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/GetProfileResourceAssociation"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetProfileResourceAssociationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * <p>
     * The ID of the profile resource association that you want to get information about.
     * </p>
     * </p>
     */
    private String profileResourceAssociationId;

    /**
     * <p>
     * <p>
     * The ID of the profile resource association that you want to get information about.
     * </p>
     * </p>
     * 
     * @param profileResourceAssociationId
     *        <p>
     *        The ID of the profile resource association that you want to get information about.
     *        </p>
     */

    public void setProfileResourceAssociationId(String profileResourceAssociationId) {
        this.profileResourceAssociationId = profileResourceAssociationId;
    }

    /**
     * <p>
     * <p>
     * The ID of the profile resource association that you want to get information about.
     * </p>
     * </p>
     * 
     * @return <p>
     *         The ID of the profile resource association that you want to get information about.
     *         </p>
     */

    public String getProfileResourceAssociationId() {
        return this.profileResourceAssociationId;
    }

    /**
     * <p>
     * <p>
     * The ID of the profile resource association that you want to get information about.
     * </p>
     * </p>
     * 
     * @param profileResourceAssociationId
     *        <p>
     *        The ID of the profile resource association that you want to get information about.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetProfileResourceAssociationRequest withProfileResourceAssociationId(String profileResourceAssociationId) {
        setProfileResourceAssociationId(profileResourceAssociationId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getProfileResourceAssociationId() != null)
            sb.append("ProfileResourceAssociationId: ").append(getProfileResourceAssociationId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetProfileResourceAssociationRequest == false)
            return false;
        GetProfileResourceAssociationRequest other = (GetProfileResourceAssociationRequest) obj;
        if (other.getProfileResourceAssociationId() == null ^ this.getProfileResourceAssociationId() == null)
            return false;
        if (other.getProfileResourceAssociationId() != null && other.getProfileResourceAssociationId().equals(this.getProfileResourceAssociationId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getProfileResourceAssociationId() == null) ? 0 : getProfileResourceAssociationId().hashCode());
        return hashCode;
    }

    @Override
    public GetProfileResourceAssociationRequest clone() {
        return (GetProfileResourceAssociationRequest) super.clone();
    }

}
