/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroups.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.resourcegroups.model.Group;
import com.amazonaws.services.resourcegroups.model.GroupConfiguration;
import com.amazonaws.services.resourcegroups.model.ResourceQuery;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateGroupResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Group group;
    private ResourceQuery resourceQuery;
    private Map<String, String> tags;
    private GroupConfiguration groupConfiguration;

    public void setGroup(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    public CreateGroupResult withGroup(Group group) {
        this.setGroup(group);
        return this;
    }

    public void setResourceQuery(ResourceQuery resourceQuery) {
        this.resourceQuery = resourceQuery;
    }

    public ResourceQuery getResourceQuery() {
        return this.resourceQuery;
    }

    public CreateGroupResult withResourceQuery(ResourceQuery resourceQuery) {
        this.setResourceQuery(resourceQuery);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateGroupResult withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateGroupResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateGroupResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setGroupConfiguration(GroupConfiguration groupConfiguration) {
        this.groupConfiguration = groupConfiguration;
    }

    public GroupConfiguration getGroupConfiguration() {
        return this.groupConfiguration;
    }

    public CreateGroupResult withGroupConfiguration(GroupConfiguration groupConfiguration) {
        this.setGroupConfiguration(groupConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroup() != null) {
            sb.append("Group: ").append(this.getGroup()).append(",");
        }
        if (this.getResourceQuery() != null) {
            sb.append("ResourceQuery: ").append(this.getResourceQuery()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getGroupConfiguration() != null) {
            sb.append("GroupConfiguration: ").append(this.getGroupConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupResult)) {
            return false;
        }
        CreateGroupResult other = (CreateGroupResult)obj;
        if (other.getGroup() == null ^ this.getGroup() == null) {
            return false;
        }
        if (other.getGroup() != null && !other.getGroup().equals(this.getGroup())) {
            return false;
        }
        if (other.getResourceQuery() == null ^ this.getResourceQuery() == null) {
            return false;
        }
        if (other.getResourceQuery() != null && !other.getResourceQuery().equals(this.getResourceQuery())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getGroupConfiguration() == null ^ this.getGroupConfiguration() == null) {
            return false;
        }
        return other.getGroupConfiguration() == null || other.getGroupConfiguration().equals(this.getGroupConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        hashCode = 31 * hashCode + (this.getResourceQuery() == null ? 0 : this.getResourceQuery().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getGroupConfiguration() == null ? 0 : this.getGroupConfiguration().hashCode());
        return hashCode;
    }

    public CreateGroupResult clone() {
        try {
            return (CreateGroupResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

