/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.SourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DescribeEventsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String sourceIdentifier;
    private String sourceType;
    private Date startTime;
    private Date endTime;
    private Integer duration;
    private ListWithAutoConstructFlag<String> eventCategories;
    private Integer maxRecords;
    private String marker;

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public DescribeEventsRequest withSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
        return this;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public DescribeEventsRequest withSourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType.toString();
    }

    public DescribeEventsRequest withSourceType(SourceType sourceType) {
        this.sourceType = sourceType.toString();
        return this;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public DescribeEventsRequest withStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public DescribeEventsRequest withEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public DescribeEventsRequest withDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public List<String> getEventCategories() {
        if (this.eventCategories == null) {
            this.eventCategories = new ListWithAutoConstructFlag();
            this.eventCategories.setAutoConstruct(true);
        }
        return this.eventCategories;
    }

    public void setEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
            return;
        }
        ListWithAutoConstructFlag eventCategoriesCopy = new ListWithAutoConstructFlag(eventCategories.size());
        eventCategoriesCopy.addAll(eventCategories);
        this.eventCategories = eventCategoriesCopy;
    }

    public DescribeEventsRequest withEventCategories(String ... eventCategories) {
        if (this.getEventCategories() == null) {
            this.setEventCategories(new ArrayList<String>(eventCategories.length));
        }
        for (String value : eventCategories) {
            this.getEventCategories().add(value);
        }
        return this;
    }

    public DescribeEventsRequest withEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
        } else {
            ListWithAutoConstructFlag eventCategoriesCopy = new ListWithAutoConstructFlag(eventCategories.size());
            eventCategoriesCopy.addAll(eventCategories);
            this.eventCategories = eventCategoriesCopy;
        }
        return this;
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
    }

    public DescribeEventsRequest withMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeEventsRequest withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceIdentifier() != null) {
            sb.append("SourceIdentifier: " + this.getSourceIdentifier() + ",");
        }
        if (this.getSourceType() != null) {
            sb.append("SourceType: " + this.getSourceType() + ",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: " + this.getStartTime() + ",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: " + this.getEndTime() + ",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: " + this.getDuration() + ",");
        }
        if (this.getEventCategories() != null) {
            sb.append("EventCategories: " + this.getEventCategories() + ",");
        }
        if (this.getMaxRecords() != null) {
            sb.append("MaxRecords: " + this.getMaxRecords() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceIdentifier() == null ? 0 : this.getSourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSourceType() == null ? 0 : this.getSourceType().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode = 31 * hashCode + (this.getEventCategories() == null ? 0 : this.getEventCategories().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRecords() == null ? 0 : this.getMaxRecords().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsRequest)) {
            return false;
        }
        DescribeEventsRequest other = (DescribeEventsRequest)obj;
        if (other.getSourceIdentifier() == null ^ this.getSourceIdentifier() == null) {
            return false;
        }
        if (other.getSourceIdentifier() != null && !other.getSourceIdentifier().equals(this.getSourceIdentifier())) {
            return false;
        }
        if (other.getSourceType() == null ^ this.getSourceType() == null) {
            return false;
        }
        if (other.getSourceType() != null && !other.getSourceType().equals(this.getSourceType())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getEventCategories() == null ^ this.getEventCategories() == null) {
            return false;
        }
        if (other.getEventCategories() != null && !other.getEventCategories().equals(this.getEventCategories())) {
            return false;
        }
        if (other.getMaxRecords() == null ^ this.getMaxRecords() == null) {
            return false;
        }
        if (other.getMaxRecords() != null && !other.getMaxRecords().equals(this.getMaxRecords())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

