/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pcaconnectorad.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.pcaconnectorad.model.TemplateSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTemplatesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<TemplateSummary> templates;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTemplatesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<TemplateSummary> getTemplates() {
        return this.templates;
    }

    public void setTemplates(Collection<TemplateSummary> templates) {
        if (templates == null) {
            this.templates = null;
            return;
        }
        this.templates = new ArrayList<TemplateSummary>(templates);
    }

    public ListTemplatesResult withTemplates(TemplateSummary ... templates) {
        if (this.templates == null) {
            this.setTemplates(new ArrayList<TemplateSummary>(templates.length));
        }
        for (TemplateSummary ele : templates) {
            this.templates.add(ele);
        }
        return this;
    }

    public ListTemplatesResult withTemplates(Collection<TemplateSummary> templates) {
        this.setTemplates(templates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getTemplates() != null) {
            sb.append("Templates: ").append(this.getTemplates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplatesResult)) {
            return false;
        }
        ListTemplatesResult other = (ListTemplatesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getTemplates() == null ^ this.getTemplates() == null) {
            return false;
        }
        return other.getTemplates() == null || other.getTemplates().equals(this.getTemplates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getTemplates() == null ? 0 : this.getTemplates().hashCode());
        return hashCode;
    }

    public ListTemplatesResult clone() {
        try {
            return (ListTemplatesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

