/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmonitor.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.networkmonitor.model.MonitorState;
import com.amazonaws.services.networkmonitor.model.Probe;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetMonitorResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String monitorArn;
    private String monitorName;
    private String state;
    private Long aggregationPeriod;
    private Map<String, String> tags;
    private List<Probe> probes;
    private Date createdAt;
    private Date modifiedAt;

    public void setMonitorArn(String monitorArn) {
        this.monitorArn = monitorArn;
    }

    public String getMonitorArn() {
        return this.monitorArn;
    }

    public GetMonitorResult withMonitorArn(String monitorArn) {
        this.setMonitorArn(monitorArn);
        return this;
    }

    public void setMonitorName(String monitorName) {
        this.monitorName = monitorName;
    }

    public String getMonitorName() {
        return this.monitorName;
    }

    public GetMonitorResult withMonitorName(String monitorName) {
        this.setMonitorName(monitorName);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public GetMonitorResult withState(String state) {
        this.setState(state);
        return this;
    }

    public GetMonitorResult withState(MonitorState state) {
        this.state = state.toString();
        return this;
    }

    public void setAggregationPeriod(Long aggregationPeriod) {
        this.aggregationPeriod = aggregationPeriod;
    }

    public Long getAggregationPeriod() {
        return this.aggregationPeriod;
    }

    public GetMonitorResult withAggregationPeriod(Long aggregationPeriod) {
        this.setAggregationPeriod(aggregationPeriod);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public GetMonitorResult withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public GetMonitorResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public GetMonitorResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<Probe> getProbes() {
        return this.probes;
    }

    public void setProbes(Collection<Probe> probes) {
        if (probes == null) {
            this.probes = null;
            return;
        }
        this.probes = new ArrayList<Probe>(probes);
    }

    public GetMonitorResult withProbes(Probe ... probes) {
        if (this.probes == null) {
            this.setProbes(new ArrayList<Probe>(probes.length));
        }
        for (Probe ele : probes) {
            this.probes.add(ele);
        }
        return this;
    }

    public GetMonitorResult withProbes(Collection<Probe> probes) {
        this.setProbes(probes);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public GetMonitorResult withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public GetMonitorResult withModifiedAt(Date modifiedAt) {
        this.setModifiedAt(modifiedAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMonitorArn() != null) {
            sb.append("MonitorArn: ").append(this.getMonitorArn()).append(",");
        }
        if (this.getMonitorName() != null) {
            sb.append("MonitorName: ").append(this.getMonitorName()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getAggregationPeriod() != null) {
            sb.append("AggregationPeriod: ").append(this.getAggregationPeriod()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getProbes() != null) {
            sb.append("Probes: ").append(this.getProbes()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getModifiedAt() != null) {
            sb.append("ModifiedAt: ").append(this.getModifiedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMonitorResult)) {
            return false;
        }
        GetMonitorResult other = (GetMonitorResult)obj;
        if (other.getMonitorArn() == null ^ this.getMonitorArn() == null) {
            return false;
        }
        if (other.getMonitorArn() != null && !other.getMonitorArn().equals(this.getMonitorArn())) {
            return false;
        }
        if (other.getMonitorName() == null ^ this.getMonitorName() == null) {
            return false;
        }
        if (other.getMonitorName() != null && !other.getMonitorName().equals(this.getMonitorName())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getAggregationPeriod() == null ^ this.getAggregationPeriod() == null) {
            return false;
        }
        if (other.getAggregationPeriod() != null && !other.getAggregationPeriod().equals(this.getAggregationPeriod())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getProbes() == null ^ this.getProbes() == null) {
            return false;
        }
        if (other.getProbes() != null && !other.getProbes().equals(this.getProbes())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getModifiedAt() == null ^ this.getModifiedAt() == null) {
            return false;
        }
        return other.getModifiedAt() == null || other.getModifiedAt().equals(this.getModifiedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMonitorArn() == null ? 0 : this.getMonitorArn().hashCode());
        hashCode = 31 * hashCode + (this.getMonitorName() == null ? 0 : this.getMonitorName().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getAggregationPeriod() == null ? 0 : this.getAggregationPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getProbes() == null ? 0 : this.getProbes().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getModifiedAt() == null ? 0 : this.getModifiedAt().hashCode());
        return hashCode;
    }

    public GetMonitorResult clone() {
        try {
            return (GetMonitorResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

