/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchain.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedblockchain.model.Proposal;
import java.util.Date;

@SdkInternalApi
public class ProposalMarshaller {
    private static final MarshallingInfo<String> PROPOSALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProposalId").build();
    private static final MarshallingInfo<String> NETWORKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetworkId").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<StructuredPojo> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Actions").build();
    private static final MarshallingInfo<String> PROPOSEDBYMEMBERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProposedByMemberId").build();
    private static final MarshallingInfo<String> PROPOSEDBYMEMBERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProposedByMemberName").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Date> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> EXPIRATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpirationDate").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Integer> YESVOTECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("YesVoteCount").build();
    private static final MarshallingInfo<Integer> NOVOTECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NoVoteCount").build();
    private static final MarshallingInfo<Integer> OUTSTANDINGVOTECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutstandingVoteCount").build();
    private static final ProposalMarshaller instance = new ProposalMarshaller();

    public static ProposalMarshaller getInstance() {
        return instance;
    }

    public void marshall(Proposal proposal, ProtocolMarshaller protocolMarshaller) {
        if (proposal == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)proposal.getProposalId(), PROPOSALID_BINDING);
            protocolMarshaller.marshall((Object)proposal.getNetworkId(), NETWORKID_BINDING);
            protocolMarshaller.marshall((Object)proposal.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)proposal.getActions(), ACTIONS_BINDING);
            protocolMarshaller.marshall((Object)proposal.getProposedByMemberId(), PROPOSEDBYMEMBERID_BINDING);
            protocolMarshaller.marshall((Object)proposal.getProposedByMemberName(), PROPOSEDBYMEMBERNAME_BINDING);
            protocolMarshaller.marshall((Object)proposal.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)proposal.getCreationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)proposal.getExpirationDate(), EXPIRATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)proposal.getYesVoteCount(), YESVOTECOUNT_BINDING);
            protocolMarshaller.marshall((Object)proposal.getNoVoteCount(), NOVOTECOUNT_BINDING);
            protocolMarshaller.marshall((Object)proposal.getOutstandingVoteCount(), OUTSTANDINGVOTECOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

