/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideosignalingchannels;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesisvideosignalingchannels.AmazonKinesisVideoSignalingChannelsAsync;
import com.amazonaws.services.kinesisvideosignalingchannels.AmazonKinesisVideoSignalingChannelsAsyncClientBuilder;
import com.amazonaws.services.kinesisvideosignalingchannels.AmazonKinesisVideoSignalingChannelsClient;
import com.amazonaws.services.kinesisvideosignalingchannels.model.GetIceServerConfigRequest;
import com.amazonaws.services.kinesisvideosignalingchannels.model.GetIceServerConfigResult;
import com.amazonaws.services.kinesisvideosignalingchannels.model.SendAlexaOfferToMasterRequest;
import com.amazonaws.services.kinesisvideosignalingchannels.model.SendAlexaOfferToMasterResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKinesisVideoSignalingChannelsAsyncClient
extends AmazonKinesisVideoSignalingChannelsClient
implements AmazonKinesisVideoSignalingChannelsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonKinesisVideoSignalingChannelsAsyncClientBuilder asyncBuilder() {
        return AmazonKinesisVideoSignalingChannelsAsyncClientBuilder.standard();
    }

    AmazonKinesisVideoSignalingChannelsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonKinesisVideoSignalingChannelsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetIceServerConfigResult> getIceServerConfigAsync(GetIceServerConfigRequest request) {
        return this.getIceServerConfigAsync(request, null);
    }

    @Override
    public Future<GetIceServerConfigResult> getIceServerConfigAsync(GetIceServerConfigRequest request, final AsyncHandler<GetIceServerConfigRequest, GetIceServerConfigResult> asyncHandler) {
        final GetIceServerConfigRequest finalRequest = (GetIceServerConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetIceServerConfigResult>(){

            @Override
            public GetIceServerConfigResult call() throws Exception {
                GetIceServerConfigResult result = null;
                try {
                    result = AmazonKinesisVideoSignalingChannelsAsyncClient.this.executeGetIceServerConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendAlexaOfferToMasterResult> sendAlexaOfferToMasterAsync(SendAlexaOfferToMasterRequest request) {
        return this.sendAlexaOfferToMasterAsync(request, null);
    }

    @Override
    public Future<SendAlexaOfferToMasterResult> sendAlexaOfferToMasterAsync(SendAlexaOfferToMasterRequest request, final AsyncHandler<SendAlexaOfferToMasterRequest, SendAlexaOfferToMasterResult> asyncHandler) {
        final SendAlexaOfferToMasterRequest finalRequest = (SendAlexaOfferToMasterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendAlexaOfferToMasterResult>(){

            @Override
            public SendAlexaOfferToMasterResult call() throws Exception {
                SendAlexaOfferToMasterResult result = null;
                try {
                    result = AmazonKinesisVideoSignalingChannelsAsyncClient.this.executeSendAlexaOfferToMaster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

