/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest;
import com.amazonaws.services.glacier.model.transform.DataRetrievalPolicyJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SetDataRetrievalPolicyRequestMarshaller
implements Marshaller<Request<SetDataRetrievalPolicyRequest>, SetDataRetrievalPolicyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SetDataRetrievalPolicyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SetDataRetrievalPolicyRequest> marshall(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest) {
        if (setDataRetrievalPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setDataRetrievalPolicyRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{accountId}/policies/data-retrieval";
        uriResourcePath = uriResourcePath.replace("{accountId}", setDataRetrievalPolicyRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)setDataRetrievalPolicyRequest.getAccountId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (setDataRetrievalPolicyRequest.getPolicy() != null) {
                jsonGenerator.writeFieldName("Policy");
                DataRetrievalPolicyJsonMarshaller.getInstance().marshall(setDataRetrievalPolicyRequest.getPolicy(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

