/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.transform.ParameterizedStatementMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ParameterizedStatement
implements Serializable,
Cloneable,
StructuredPojo {
    private String statement;
    private List<AttributeValue> parameters;

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public String getStatement() {
        return this.statement;
    }

    public ParameterizedStatement withStatement(String statement) {
        this.setStatement(statement);
        return this;
    }

    public List<AttributeValue> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<AttributeValue> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<AttributeValue>(parameters);
    }

    public ParameterizedStatement withParameters(AttributeValue ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<AttributeValue>(parameters.length));
        }
        for (AttributeValue ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public ParameterizedStatement withParameters(Collection<AttributeValue> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatement() != null) {
            sb.append("Statement: ").append(this.getStatement()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterizedStatement)) {
            return false;
        }
        ParameterizedStatement other = (ParameterizedStatement)obj;
        if (other.getStatement() == null ^ this.getStatement() == null) {
            return false;
        }
        if (other.getStatement() != null && !other.getStatement().equals(this.getStatement())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatement() == null ? 0 : this.getStatement().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public ParameterizedStatement clone() {
        try {
            return (ParameterizedStatement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterizedStatementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

