/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class GetItemRequestMarshaller
implements Marshaller<Request<GetItemRequest>, GetItemRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetItemRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetItemRequest> marshall(GetItemRequest getItemRequest) {
        if (getItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getItemRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.GetItem");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, String> expressionAttributeNamesMap;
            List<String> attributesToGetList;
            Map<String, AttributeValue> keyMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getItemRequest.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(getItemRequest.getTableName());
            }
            if ((keyMap = getItemRequest.getKey()) != null) {
                jsonGenerator.writeFieldName("Key");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> keyMapValue : keyMap.entrySet()) {
                    if (keyMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)keyMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall((AttributeValue)keyMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((attributesToGetList = getItemRequest.getAttributesToGet()) != null) {
                jsonGenerator.writeFieldName("AttributesToGet");
                jsonGenerator.writeStartArray();
                for (String string : attributesToGetList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if (getItemRequest.getConsistentRead() != null) {
                jsonGenerator.writeFieldName("ConsistentRead").writeValue(getItemRequest.getConsistentRead().booleanValue());
            }
            if (getItemRequest.getReturnConsumedCapacity() != null) {
                jsonGenerator.writeFieldName("ReturnConsumedCapacity").writeValue(getItemRequest.getReturnConsumedCapacity());
            }
            if (getItemRequest.getProjectionExpression() != null) {
                jsonGenerator.writeFieldName("ProjectionExpression").writeValue(getItemRequest.getProjectionExpression());
            }
            if ((expressionAttributeNamesMap = getItemRequest.getExpressionAttributeNames()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeNames");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> entry : expressionAttributeNamesMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    jsonGenerator.writeValue(entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

