/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.customerprofiles.model.DestinationSummary;
import com.amazonaws.services.customerprofiles.model.EventStreamState;
import com.amazonaws.services.customerprofiles.model.transform.EventStreamSummaryMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class EventStreamSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String domainName;
    private String eventStreamName;
    private String eventStreamArn;
    private String state;
    private Date stoppedSince;
    private DestinationSummary destinationSummary;
    private Map<String, String> tags;

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public EventStreamSummary withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setEventStreamName(String eventStreamName) {
        this.eventStreamName = eventStreamName;
    }

    public String getEventStreamName() {
        return this.eventStreamName;
    }

    public EventStreamSummary withEventStreamName(String eventStreamName) {
        this.setEventStreamName(eventStreamName);
        return this;
    }

    public void setEventStreamArn(String eventStreamArn) {
        this.eventStreamArn = eventStreamArn;
    }

    public String getEventStreamArn() {
        return this.eventStreamArn;
    }

    public EventStreamSummary withEventStreamArn(String eventStreamArn) {
        this.setEventStreamArn(eventStreamArn);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public EventStreamSummary withState(String state) {
        this.setState(state);
        return this;
    }

    public EventStreamSummary withState(EventStreamState state) {
        this.state = state.toString();
        return this;
    }

    public void setStoppedSince(Date stoppedSince) {
        this.stoppedSince = stoppedSince;
    }

    public Date getStoppedSince() {
        return this.stoppedSince;
    }

    public EventStreamSummary withStoppedSince(Date stoppedSince) {
        this.setStoppedSince(stoppedSince);
        return this;
    }

    public void setDestinationSummary(DestinationSummary destinationSummary) {
        this.destinationSummary = destinationSummary;
    }

    public DestinationSummary getDestinationSummary() {
        return this.destinationSummary;
    }

    public EventStreamSummary withDestinationSummary(DestinationSummary destinationSummary) {
        this.setDestinationSummary(destinationSummary);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public EventStreamSummary withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public EventStreamSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public EventStreamSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getEventStreamName() != null) {
            sb.append("EventStreamName: ").append(this.getEventStreamName()).append(",");
        }
        if (this.getEventStreamArn() != null) {
            sb.append("EventStreamArn: ").append(this.getEventStreamArn()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStoppedSince() != null) {
            sb.append("StoppedSince: ").append(this.getStoppedSince()).append(",");
        }
        if (this.getDestinationSummary() != null) {
            sb.append("DestinationSummary: ").append(this.getDestinationSummary()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventStreamSummary)) {
            return false;
        }
        EventStreamSummary other = (EventStreamSummary)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getEventStreamName() == null ^ this.getEventStreamName() == null) {
            return false;
        }
        if (other.getEventStreamName() != null && !other.getEventStreamName().equals(this.getEventStreamName())) {
            return false;
        }
        if (other.getEventStreamArn() == null ^ this.getEventStreamArn() == null) {
            return false;
        }
        if (other.getEventStreamArn() != null && !other.getEventStreamArn().equals(this.getEventStreamArn())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStoppedSince() == null ^ this.getStoppedSince() == null) {
            return false;
        }
        if (other.getStoppedSince() != null && !other.getStoppedSince().equals(this.getStoppedSince())) {
            return false;
        }
        if (other.getDestinationSummary() == null ^ this.getDestinationSummary() == null) {
            return false;
        }
        if (other.getDestinationSummary() != null && !other.getDestinationSummary().equals(this.getDestinationSummary())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getEventStreamName() == null ? 0 : this.getEventStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getEventStreamArn() == null ? 0 : this.getEventStreamArn().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStoppedSince() == null ? 0 : this.getStoppedSince().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationSummary() == null ? 0 : this.getDestinationSummary().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public EventStreamSummary clone() {
        try {
            return (EventStreamSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventStreamSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

