/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.ContactState;
import com.amazonaws.services.connect.model.transform.ContactFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContactFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> contactStates;

    public List<String> getContactStates() {
        return this.contactStates;
    }

    public void setContactStates(Collection<String> contactStates) {
        if (contactStates == null) {
            this.contactStates = null;
            return;
        }
        this.contactStates = new ArrayList<String>(contactStates);
    }

    public ContactFilter withContactStates(String ... contactStates) {
        if (this.contactStates == null) {
            this.setContactStates(new ArrayList<String>(contactStates.length));
        }
        for (String ele : contactStates) {
            this.contactStates.add(ele);
        }
        return this;
    }

    public ContactFilter withContactStates(Collection<String> contactStates) {
        this.setContactStates(contactStates);
        return this;
    }

    public ContactFilter withContactStates(ContactState ... contactStates) {
        ArrayList<String> contactStatesCopy = new ArrayList<String>(contactStates.length);
        for (ContactState value : contactStates) {
            contactStatesCopy.add(value.toString());
        }
        if (this.getContactStates() == null) {
            this.setContactStates(contactStatesCopy);
        } else {
            this.getContactStates().addAll(contactStatesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContactStates() != null) {
            sb.append("ContactStates: ").append(this.getContactStates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFilter)) {
            return false;
        }
        ContactFilter other = (ContactFilter)obj;
        if (other.getContactStates() == null ^ this.getContactStates() == null) {
            return false;
        }
        return other.getContactStates() == null || other.getContactStates().equals(this.getContactStates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContactStates() == null ? 0 : this.getContactStates().hashCode());
        return hashCode;
    }

    public ContactFilter clone() {
        try {
            return (ContactFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContactFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

