/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurusecurity;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.codegurusecurity.AmazonCodeGuruSecurity;
import com.amazonaws.services.codegurusecurity.AmazonCodeGuruSecurityClientBuilder;
import com.amazonaws.services.codegurusecurity.model.AmazonCodeGuruSecurityException;
import com.amazonaws.services.codegurusecurity.model.BatchGetFindingsRequest;
import com.amazonaws.services.codegurusecurity.model.BatchGetFindingsResult;
import com.amazonaws.services.codegurusecurity.model.CreateScanRequest;
import com.amazonaws.services.codegurusecurity.model.CreateScanResult;
import com.amazonaws.services.codegurusecurity.model.CreateUploadUrlRequest;
import com.amazonaws.services.codegurusecurity.model.CreateUploadUrlResult;
import com.amazonaws.services.codegurusecurity.model.GetAccountConfigurationRequest;
import com.amazonaws.services.codegurusecurity.model.GetAccountConfigurationResult;
import com.amazonaws.services.codegurusecurity.model.GetFindingsRequest;
import com.amazonaws.services.codegurusecurity.model.GetFindingsResult;
import com.amazonaws.services.codegurusecurity.model.GetMetricsSummaryRequest;
import com.amazonaws.services.codegurusecurity.model.GetMetricsSummaryResult;
import com.amazonaws.services.codegurusecurity.model.GetScanRequest;
import com.amazonaws.services.codegurusecurity.model.GetScanResult;
import com.amazonaws.services.codegurusecurity.model.ListFindingsMetricsRequest;
import com.amazonaws.services.codegurusecurity.model.ListFindingsMetricsResult;
import com.amazonaws.services.codegurusecurity.model.ListScansRequest;
import com.amazonaws.services.codegurusecurity.model.ListScansResult;
import com.amazonaws.services.codegurusecurity.model.ListTagsForResourceRequest;
import com.amazonaws.services.codegurusecurity.model.ListTagsForResourceResult;
import com.amazonaws.services.codegurusecurity.model.TagResourceRequest;
import com.amazonaws.services.codegurusecurity.model.TagResourceResult;
import com.amazonaws.services.codegurusecurity.model.UntagResourceRequest;
import com.amazonaws.services.codegurusecurity.model.UntagResourceResult;
import com.amazonaws.services.codegurusecurity.model.UpdateAccountConfigurationRequest;
import com.amazonaws.services.codegurusecurity.model.UpdateAccountConfigurationResult;
import com.amazonaws.services.codegurusecurity.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.BatchGetFindingsRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.BatchGetFindingsResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.CreateScanRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.CreateScanResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.CreateUploadUrlRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.CreateUploadUrlResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.GetAccountConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.GetAccountConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.GetFindingsRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.GetFindingsResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.GetMetricsSummaryRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.GetMetricsSummaryResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.GetScanRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.GetScanResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.ListFindingsMetricsRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.ListFindingsMetricsResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.ListScansRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.ListScansResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.UpdateAccountConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.UpdateAccountConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.codegurusecurity.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonCodeGuruSecurityClient
extends AmazonWebServiceClient
implements AmazonCodeGuruSecurity {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCodeGuruSecurity.class);
    private static final String DEFAULT_SIGNING_NAME = "codeguru-security";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonCodeGuruSecurityException.class));

    public static AmazonCodeGuruSecurityClientBuilder builder() {
        return AmazonCodeGuruSecurityClientBuilder.standard();
    }

    AmazonCodeGuruSecurityClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonCodeGuruSecurityClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("codeguru-security.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codegurusecurity/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codegurusecurity/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchGetFindingsResult batchGetFindings(BatchGetFindingsRequest request) {
        request = (BatchGetFindingsRequest)this.beforeClientExecution(request);
        return this.executeBatchGetFindings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetFindingsResult executeBatchGetFindings(BatchGetFindingsRequest batchGetFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetFindingsRequestProtocolMarshaller(protocolFactory).marshall((BatchGetFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetFindings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetFindingsResult batchGetFindingsResult = (BatchGetFindingsResult)response.getAwsResponse();
            return batchGetFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateScanResult createScan(CreateScanRequest request) {
        request = (CreateScanRequest)this.beforeClientExecution(request);
        return this.executeCreateScan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateScanResult executeCreateScan(CreateScanRequest createScanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createScanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateScanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateScanRequestProtocolMarshaller(protocolFactory).marshall((CreateScanRequest)super.beforeMarshalling((AmazonWebServiceRequest)createScanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateScan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateScanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateScanResult createScanResult = (CreateScanResult)response.getAwsResponse();
            return createScanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateUploadUrlResult createUploadUrl(CreateUploadUrlRequest request) {
        request = (CreateUploadUrlRequest)this.beforeClientExecution(request);
        return this.executeCreateUploadUrl(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateUploadUrlResult executeCreateUploadUrl(CreateUploadUrlRequest createUploadUrlRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createUploadUrlRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateUploadUrlRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateUploadUrlRequestProtocolMarshaller(protocolFactory).marshall((CreateUploadUrlRequest)super.beforeMarshalling((AmazonWebServiceRequest)createUploadUrlRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateUploadUrl");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateUploadUrlResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateUploadUrlResult createUploadUrlResult = (CreateUploadUrlResult)response.getAwsResponse();
            return createUploadUrlResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccountConfigurationResult getAccountConfiguration(GetAccountConfigurationRequest request) {
        request = (GetAccountConfigurationRequest)this.beforeClientExecution(request);
        return this.executeGetAccountConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccountConfigurationResult executeGetAccountConfiguration(GetAccountConfigurationRequest getAccountConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccountConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccountConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccountConfigurationRequestProtocolMarshaller(protocolFactory).marshall((GetAccountConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccountConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccountConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAccountConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAccountConfigurationResult getAccountConfigurationResult = (GetAccountConfigurationResult)response.getAwsResponse();
            return getAccountConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetFindingsResult getFindings(GetFindingsRequest request) {
        request = (GetFindingsRequest)this.beforeClientExecution(request);
        return this.executeGetFindings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetFindingsResult executeGetFindings(GetFindingsRequest getFindingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getFindingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetFindingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetFindingsRequestProtocolMarshaller(protocolFactory).marshall((GetFindingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getFindingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetFindings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetFindingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetFindingsResult getFindingsResult = (GetFindingsResult)response.getAwsResponse();
            return getFindingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMetricsSummaryResult getMetricsSummary(GetMetricsSummaryRequest request) {
        request = (GetMetricsSummaryRequest)this.beforeClientExecution(request);
        return this.executeGetMetricsSummary(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMetricsSummaryResult executeGetMetricsSummary(GetMetricsSummaryRequest getMetricsSummaryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMetricsSummaryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMetricsSummaryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMetricsSummaryRequestProtocolMarshaller(protocolFactory).marshall((GetMetricsSummaryRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMetricsSummaryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMetricsSummary");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMetricsSummaryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMetricsSummaryResult getMetricsSummaryResult = (GetMetricsSummaryResult)response.getAwsResponse();
            return getMetricsSummaryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetScanResult getScan(GetScanRequest request) {
        request = (GetScanRequest)this.beforeClientExecution(request);
        return this.executeGetScan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetScanResult executeGetScan(GetScanRequest getScanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getScanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetScanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetScanRequestProtocolMarshaller(protocolFactory).marshall((GetScanRequest)super.beforeMarshalling((AmazonWebServiceRequest)getScanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetScan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetScanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetScanResult getScanResult = (GetScanResult)response.getAwsResponse();
            return getScanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFindingsMetricsResult listFindingsMetrics(ListFindingsMetricsRequest request) {
        request = (ListFindingsMetricsRequest)this.beforeClientExecution(request);
        return this.executeListFindingsMetrics(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFindingsMetricsResult executeListFindingsMetrics(ListFindingsMetricsRequest listFindingsMetricsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFindingsMetricsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFindingsMetricsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFindingsMetricsRequestProtocolMarshaller(protocolFactory).marshall((ListFindingsMetricsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFindingsMetricsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListFindingsMetrics");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFindingsMetricsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFindingsMetricsResult listFindingsMetricsResult = (ListFindingsMetricsResult)response.getAwsResponse();
            return listFindingsMetricsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListScansResult listScans(ListScansRequest request) {
        request = (ListScansRequest)this.beforeClientExecution(request);
        return this.executeListScans(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListScansResult executeListScans(ListScansRequest listScansRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listScansRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListScansRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListScansRequestProtocolMarshaller(protocolFactory).marshall((ListScansRequest)super.beforeMarshalling((AmazonWebServiceRequest)listScansRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListScans");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListScansResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListScansResult listScansResult = (ListScansResult)response.getAwsResponse();
            return listScansResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAccountConfigurationResult updateAccountConfiguration(UpdateAccountConfigurationRequest request) {
        request = (UpdateAccountConfigurationRequest)this.beforeClientExecution(request);
        return this.executeUpdateAccountConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAccountConfigurationResult executeUpdateAccountConfiguration(UpdateAccountConfigurationRequest updateAccountConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAccountConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAccountConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAccountConfigurationRequestProtocolMarshaller(protocolFactory).marshall((UpdateAccountConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAccountConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeGuru Security");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAccountConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAccountConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAccountConfigurationResult updateAccountConfigurationResult = (UpdateAccountConfigurationResult)response.getAwsResponse();
            return updateAccountConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

