/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudformation.AmazonCloudFormationAsync;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostResult;
import com.amazonaws.services.cloudformation.model.GetStackPolicyRequest;
import com.amazonaws.services.cloudformation.model.GetStackPolicyResult;
import com.amazonaws.services.cloudformation.model.GetTemplateRequest;
import com.amazonaws.services.cloudformation.model.GetTemplateResult;
import com.amazonaws.services.cloudformation.model.ListStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesResult;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.services.cloudformation.model.ListStacksResult;
import com.amazonaws.services.cloudformation.model.SetStackPolicyRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import com.amazonaws.services.cloudformation.model.ValidateTemplateRequest;
import com.amazonaws.services.cloudformation.model.ValidateTemplateResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonCloudFormationAsyncClient
extends AmazonCloudFormationClient
implements AmazonCloudFormationAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonCloudFormationAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCloudFormationAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCloudFormationAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<ValidateTemplateResult> validateTemplateAsync(final ValidateTemplateRequest validateTemplateRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ValidateTemplateResult>(){

            @Override
            public ValidateTemplateResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.validateTemplate(validateTemplateRequest);
            }
        });
    }

    @Override
    public Future<ValidateTemplateResult> validateTemplateAsync(final ValidateTemplateRequest validateTemplateRequest, final AsyncHandler<ValidateTemplateRequest, ValidateTemplateResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ValidateTemplateResult>(){

            @Override
            public ValidateTemplateResult call() throws Exception {
                ValidateTemplateResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.validateTemplate(validateTemplateRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)validateTemplateRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(final DescribeStacksRequest describeStacksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStacksResult>(){

            @Override
            public DescribeStacksResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.describeStacks(describeStacksRequest);
            }
        });
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(final DescribeStacksRequest describeStacksRequest, final AsyncHandler<DescribeStacksRequest, DescribeStacksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStacksResult>(){

            @Override
            public DescribeStacksResult call() throws Exception {
                DescribeStacksResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStacks(describeStacksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeStacksRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetTemplateResult> getTemplateAsync(final GetTemplateRequest getTemplateRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTemplateResult>(){

            @Override
            public GetTemplateResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.getTemplate(getTemplateRequest);
            }
        });
    }

    @Override
    public Future<GetTemplateResult> getTemplateAsync(final GetTemplateRequest getTemplateRequest, final AsyncHandler<GetTemplateRequest, GetTemplateResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTemplateResult>(){

            @Override
            public GetTemplateResult call() throws Exception {
                GetTemplateResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.getTemplate(getTemplateRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getTemplateRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetStackPolicyResult> getStackPolicyAsync(final GetStackPolicyRequest getStackPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetStackPolicyResult>(){

            @Override
            public GetStackPolicyResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.getStackPolicy(getStackPolicyRequest);
            }
        });
    }

    @Override
    public Future<GetStackPolicyResult> getStackPolicyAsync(final GetStackPolicyRequest getStackPolicyRequest, final AsyncHandler<GetStackPolicyRequest, GetStackPolicyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetStackPolicyResult>(){

            @Override
            public GetStackPolicyResult call() throws Exception {
                GetStackPolicyResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.getStackPolicy(getStackPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getStackPolicyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListStacksResult> listStacksAsync(final ListStacksRequest listStacksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStacksResult>(){

            @Override
            public ListStacksResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.listStacks(listStacksRequest);
            }
        });
    }

    @Override
    public Future<ListStacksResult> listStacksAsync(final ListStacksRequest listStacksRequest, final AsyncHandler<ListStacksRequest, ListStacksResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStacksResult>(){

            @Override
            public ListStacksResult call() throws Exception {
                ListStacksResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.listStacks(listStacksRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listStacksRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateStackResult> createStackAsync(final CreateStackRequest createStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateStackResult>(){

            @Override
            public CreateStackResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.createStack(createStackRequest);
            }
        });
    }

    @Override
    public Future<CreateStackResult> createStackAsync(final CreateStackRequest createStackRequest, final AsyncHandler<CreateStackRequest, CreateStackResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateStackResult>(){

            @Override
            public CreateStackResult call() throws Exception {
                CreateStackResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.createStack(createStackRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createStackRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> setStackPolicyAsync(final SetStackPolicyRequest setStackPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudFormationAsyncClient.this.setStackPolicy(setStackPolicyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setStackPolicyAsync(final SetStackPolicyRequest setStackPolicyRequest, final AsyncHandler<SetStackPolicyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonCloudFormationAsyncClient.this.setStackPolicy(setStackPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)setStackPolicyRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<EstimateTemplateCostResult> estimateTemplateCostAsync(final EstimateTemplateCostRequest estimateTemplateCostRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EstimateTemplateCostResult>(){

            @Override
            public EstimateTemplateCostResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.estimateTemplateCost(estimateTemplateCostRequest);
            }
        });
    }

    @Override
    public Future<EstimateTemplateCostResult> estimateTemplateCostAsync(final EstimateTemplateCostRequest estimateTemplateCostRequest, final AsyncHandler<EstimateTemplateCostRequest, EstimateTemplateCostResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EstimateTemplateCostResult>(){

            @Override
            public EstimateTemplateCostResult call() throws Exception {
                EstimateTemplateCostResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.estimateTemplateCost(estimateTemplateCostRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)estimateTemplateCostRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStackEventsResult> describeStackEventsAsync(final DescribeStackEventsRequest describeStackEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStackEventsResult>(){

            @Override
            public DescribeStackEventsResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.describeStackEvents(describeStackEventsRequest);
            }
        });
    }

    @Override
    public Future<DescribeStackEventsResult> describeStackEventsAsync(final DescribeStackEventsRequest describeStackEventsRequest, final AsyncHandler<DescribeStackEventsRequest, DescribeStackEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStackEventsResult>(){

            @Override
            public DescribeStackEventsResult call() throws Exception {
                DescribeStackEventsResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStackEvents(describeStackEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeStackEventsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStackResourceResult> describeStackResourceAsync(final DescribeStackResourceRequest describeStackResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStackResourceResult>(){

            @Override
            public DescribeStackResourceResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.describeStackResource(describeStackResourceRequest);
            }
        });
    }

    @Override
    public Future<DescribeStackResourceResult> describeStackResourceAsync(final DescribeStackResourceRequest describeStackResourceRequest, final AsyncHandler<DescribeStackResourceRequest, DescribeStackResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStackResourceResult>(){

            @Override
            public DescribeStackResourceResult call() throws Exception {
                DescribeStackResourceResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStackResource(describeStackResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeStackResourceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> cancelUpdateStackAsync(final CancelUpdateStackRequest cancelUpdateStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudFormationAsyncClient.this.cancelUpdateStack(cancelUpdateStackRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> cancelUpdateStackAsync(final CancelUpdateStackRequest cancelUpdateStackRequest, final AsyncHandler<CancelUpdateStackRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonCloudFormationAsyncClient.this.cancelUpdateStack(cancelUpdateStackRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)cancelUpdateStackRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<UpdateStackResult> updateStackAsync(final UpdateStackRequest updateStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateStackResult>(){

            @Override
            public UpdateStackResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.updateStack(updateStackRequest);
            }
        });
    }

    @Override
    public Future<UpdateStackResult> updateStackAsync(final UpdateStackRequest updateStackRequest, final AsyncHandler<UpdateStackRequest, UpdateStackResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateStackResult>(){

            @Override
            public UpdateStackResult call() throws Exception {
                UpdateStackResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.updateStack(updateStackRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateStackRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStackResourcesResult> describeStackResourcesAsync(final DescribeStackResourcesRequest describeStackResourcesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStackResourcesResult>(){

            @Override
            public DescribeStackResourcesResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.describeStackResources(describeStackResourcesRequest);
            }
        });
    }

    @Override
    public Future<DescribeStackResourcesResult> describeStackResourcesAsync(final DescribeStackResourcesRequest describeStackResourcesRequest, final AsyncHandler<DescribeStackResourcesRequest, DescribeStackResourcesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStackResourcesResult>(){

            @Override
            public DescribeStackResourcesResult call() throws Exception {
                DescribeStackResourcesResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.describeStackResources(describeStackResourcesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeStackResourcesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteStackAsync(final DeleteStackRequest deleteStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudFormationAsyncClient.this.deleteStack(deleteStackRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteStackAsync(final DeleteStackRequest deleteStackRequest, final AsyncHandler<DeleteStackRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonCloudFormationAsyncClient.this.deleteStack(deleteStackRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteStackRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListStackResourcesResult> listStackResourcesAsync(final ListStackResourcesRequest listStackResourcesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStackResourcesResult>(){

            @Override
            public ListStackResourcesResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.listStackResources(listStackResourcesRequest);
            }
        });
    }

    @Override
    public Future<ListStackResourcesResult> listStackResourcesAsync(final ListStackResourcesRequest listStackResourcesRequest, final AsyncHandler<ListStackResourcesRequest, ListStackResourcesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStackResourcesResult>(){

            @Override
            public ListStackResourcesResult call() throws Exception {
                ListStackResourcesResult result;
                try {
                    result = AmazonCloudFormationAsyncClient.this.listStackResources(listStackResourcesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listStackResourcesRequest, (Object)result);
                return result;
            }
        });
    }
}

