/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chime.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Settings specific for Amazon Transcribe as the live transcription engine.
 * </p>
 * <p>
 * If you specify an invalid combination of parameters, a <code>TranscriptFailed</code> event will be sent with the
 * contents of the <code>BadRequestException</code> generated by Amazon Transcribe. For more information on each
 * parameter and which combinations are valid, refer to the <a
 * href="https://docs.aws.amazon.com/transcribe/latest/APIReference/API_streaming_StartStreamTranscription.html"
 * >StartStreamTranscription</a> API in the <i>Amazon Transcribe Developer Guide</i>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/EngineTranscribeSettings" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EngineTranscribeSettings implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Specify the language code that represents the language spoken.
     * </p>
     * <p>
     * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
     * automatic language identification.
     * </p>
     */
    private String languageCode;
    /**
     * <p>
     * Specify how you want your vocabulary filter applied to your transcript.
     * </p>
     * <p>
     * To replace words with <code>***</code>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     */
    private String vocabularyFilterMethod;
    /**
     * <p>
     * Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note
     * that vocabulary filter names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in
     * each Region.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code> and want to use one or more vocabulary filters with your
     * transcription, use the <code>VocabularyFilterNames</code> parameter instead.
     * </p>
     */
    private String vocabularyFilterName;
    /**
     * <p>
     * Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe multiple Regions, the vocabulary must be available in Amazon Transcribe in each
     * Region.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code> and want to use one or more custom vocabularies with your
     * transcription, use the <code>VocabularyNames</code> parameter instead.
     * </p>
     */
    private String vocabularyName;
    /**
     * <p>
     * The AWS Region in which to use Amazon Transcribe.
     * </p>
     * <p>
     * If you don't specify a Region, then the <code>MediaRegion</code> parameter of the <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html"
     * >CreateMeeting.html</a> API will be used. However, if Amazon Transcribe is not available in the
     * <code>MediaRegion</code>, then a TranscriptFailed event is sent.
     * </p>
     * <p>
     * Use <code>auto</code> to use Amazon Transcribe in a Region near the meeting’s <code>MediaRegion</code>. For more
     * information, refer to <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region">Choosing a
     * transcription Region</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     */
    private String region;
    /**
     * <p>
     * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in
     * your output, but may impact accuracy.
     * </p>
     */
    private Boolean enablePartialResultsStabilization;
    /**
     * <p>
     * Specify the level of stability to use when you enable partial results stabilization (
     * <code>EnablePartialResultsStabilization</code>).
     * </p>
     * <p>
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     * </p>
     */
    private String partialResultsStability;
    /**
     * <p>
     * Labels all personally identifiable information (PII) identified in your transcript. If you don't include
     * <code>PiiEntityTypes</code>, all PII is identified.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * </p>
     */
    private String contentIdentificationType;
    /**
     * <p>
     * Content redaction is performed at the segment level. If you don't include <code>PiiEntityTypes</code>, all PII is
     * redacted.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * </p>
     */
    private String contentRedactionType;
    /**
     * <p>
     * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can
     * include as many types as you'd like, or you can select <code>ALL</code>.
     * </p>
     * <p>
     * Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
     * <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>
     * <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>,<code>NAME</code>, <code>PHONE</code>, <code>PIN</code>,
     * <code>SSN</code>, or <code>ALL</code>.
     * </p>
     * <p>
     * Note that if you include <code>PiiEntityTypes</code>, you must also include
     * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
     * </p>
     * <p>
     * If you include <code>ContentRedactionType</code> or <code>ContentIdentificationType</code>, but do not include
     * <code>PiiEntityTypes</code>, all PII is redacted or identified.
     * </p>
     */
    private String piiEntityTypes;
    /**
     * <p>
     * Specify the name of the custom language model that you want to use when processing your transcription. Note that
     * language model names are case sensitive.
     * </p>
     * <p>
     * The language of the specified language model must match the language code. If the languages don't match, the
     * custom language model isn't applied. There are no errors or warnings associated with a language mismatch.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the custom language model must be available in Amazon
     * Transcribe in each Region.
     * </p>
     */
    private String languageModelName;
    /**
     * <p>
     * Enables automatic language identification for your transcription.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code>, you can optionally use <code>LanguageOptions</code> to include a
     * list of language codes that you think may be present in your audio stream. Including language options can improve
     * transcription accuracy.
     * </p>
     * <p>
     * You can also use <code>PreferredLanguage</code> to include a preferred language. Doing so can help Amazon
     * Transcribe identify the language faster.
     * </p>
     * <p>
     * You must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code>.
     * </p>
     * <p>
     * Language identification can't be combined with custom language models or redaction.
     * </p>
     */
    private Boolean identifyLanguage;
    /**
     * <p>
     * Specify two or more language codes that represent the languages you think may be present in your media; including
     * more than five is not recommended. If you're unsure what languages are present, do not include this parameter.
     * </p>
     * <p>
     * Including language options can improve the accuracy of language identification.
     * </p>
     * <p>
     * If you include <code>LanguageOptions</code>, you must also include <code>IdentifyLanguage</code>.
     * </p>
     * <important>
     * <p>
     * You can only include one language dialect per language. For example, you cannot include <code>en-US</code> and
     * <code>en-AU</code>.
     * </p>
     * </important>
     */
    private String languageOptions;
    /**
     * <p>
     * Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.
     * </p>
     * <p>
     * You can only use this parameter if you include <code>IdentifyLanguage</code> and <code>LanguageOptions</code>.
     * </p>
     */
    private String preferredLanguage;
    /**
     * <p>
     * Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary must be available in Amazon Transcribe in each
     * Region.
     * </p>
     * <p>
     * If you don't include <code>IdentifyLanguage</code> and want to use a custom vocabulary with your transcription,
     * use the <code>VocabularyName</code> parameter instead.
     * </p>
     */
    private String vocabularyNames;
    /**
     * <p>
     * Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note
     * that vocabulary filter names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in
     * each Region.
     * </p>
     * <p>
     * If you're <i>not</i> including <code>IdentifyLanguage</code> and want to use a custom vocabulary filter with your
     * transcription, use the <code>VocabularyFilterName</code> parameter instead.
     * </p>
     */
    private String vocabularyFilterNames;

    /**
     * <p>
     * Specify the language code that represents the language spoken.
     * </p>
     * <p>
     * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
     * automatic language identification.
     * </p>
     * 
     * @param languageCode
     *        Specify the language code that represents the language spoken.</p>
     *        <p>
     *        If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
     *        enable automatic language identification.
     * @see TranscribeLanguageCode
     */

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    /**
     * <p>
     * Specify the language code that represents the language spoken.
     * </p>
     * <p>
     * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
     * automatic language identification.
     * </p>
     * 
     * @return Specify the language code that represents the language spoken.</p>
     *         <p>
     *         If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
     *         enable automatic language identification.
     * @see TranscribeLanguageCode
     */

    public String getLanguageCode() {
        return this.languageCode;
    }

    /**
     * <p>
     * Specify the language code that represents the language spoken.
     * </p>
     * <p>
     * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
     * automatic language identification.
     * </p>
     * 
     * @param languageCode
     *        Specify the language code that represents the language spoken.</p>
     *        <p>
     *        If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
     *        enable automatic language identification.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeLanguageCode
     */

    public EngineTranscribeSettings withLanguageCode(String languageCode) {
        setLanguageCode(languageCode);
        return this;
    }

    /**
     * <p>
     * Specify the language code that represents the language spoken.
     * </p>
     * <p>
     * If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable
     * automatic language identification.
     * </p>
     * 
     * @param languageCode
     *        Specify the language code that represents the language spoken.</p>
     *        <p>
     *        If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to
     *        enable automatic language identification.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeLanguageCode
     */

    public EngineTranscribeSettings withLanguageCode(TranscribeLanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    /**
     * <p>
     * Specify how you want your vocabulary filter applied to your transcript.
     * </p>
     * <p>
     * To replace words with <code>***</code>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * 
     * @param vocabularyFilterMethod
     *        Specify how you want your vocabulary filter applied to your transcript.</p>
     *        <p>
     *        To replace words with <code>***</code>, choose <code>mask</code>.
     *        </p>
     *        <p>
     *        To delete words, choose <code>remove</code>.
     *        </p>
     *        <p>
     *        To flag words without changing them, choose <code>tag</code>.
     * @see TranscribeVocabularyFilterMethod
     */

    public void setVocabularyFilterMethod(String vocabularyFilterMethod) {
        this.vocabularyFilterMethod = vocabularyFilterMethod;
    }

    /**
     * <p>
     * Specify how you want your vocabulary filter applied to your transcript.
     * </p>
     * <p>
     * To replace words with <code>***</code>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * 
     * @return Specify how you want your vocabulary filter applied to your transcript.</p>
     *         <p>
     *         To replace words with <code>***</code>, choose <code>mask</code>.
     *         </p>
     *         <p>
     *         To delete words, choose <code>remove</code>.
     *         </p>
     *         <p>
     *         To flag words without changing them, choose <code>tag</code>.
     * @see TranscribeVocabularyFilterMethod
     */

    public String getVocabularyFilterMethod() {
        return this.vocabularyFilterMethod;
    }

    /**
     * <p>
     * Specify how you want your vocabulary filter applied to your transcript.
     * </p>
     * <p>
     * To replace words with <code>***</code>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * 
     * @param vocabularyFilterMethod
     *        Specify how you want your vocabulary filter applied to your transcript.</p>
     *        <p>
     *        To replace words with <code>***</code>, choose <code>mask</code>.
     *        </p>
     *        <p>
     *        To delete words, choose <code>remove</code>.
     *        </p>
     *        <p>
     *        To flag words without changing them, choose <code>tag</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeVocabularyFilterMethod
     */

    public EngineTranscribeSettings withVocabularyFilterMethod(String vocabularyFilterMethod) {
        setVocabularyFilterMethod(vocabularyFilterMethod);
        return this;
    }

    /**
     * <p>
     * Specify how you want your vocabulary filter applied to your transcript.
     * </p>
     * <p>
     * To replace words with <code>***</code>, choose <code>mask</code>.
     * </p>
     * <p>
     * To delete words, choose <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, choose <code>tag</code>.
     * </p>
     * 
     * @param vocabularyFilterMethod
     *        Specify how you want your vocabulary filter applied to your transcript.</p>
     *        <p>
     *        To replace words with <code>***</code>, choose <code>mask</code>.
     *        </p>
     *        <p>
     *        To delete words, choose <code>remove</code>.
     *        </p>
     *        <p>
     *        To flag words without changing them, choose <code>tag</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeVocabularyFilterMethod
     */

    public EngineTranscribeSettings withVocabularyFilterMethod(TranscribeVocabularyFilterMethod vocabularyFilterMethod) {
        this.vocabularyFilterMethod = vocabularyFilterMethod.toString();
        return this;
    }

    /**
     * <p>
     * Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note
     * that vocabulary filter names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in
     * each Region.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code> and want to use one or more vocabulary filters with your
     * transcription, use the <code>VocabularyFilterNames</code> parameter instead.
     * </p>
     * 
     * @param vocabularyFilterName
     *        Specify the name of the custom vocabulary filter that you want to use when processing your transcription.
     *        Note that vocabulary filter names are case sensitive. </p>
     *        <p>
     *        If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon
     *        Transcribe in each Region.
     *        </p>
     *        <p>
     *        If you include <code>IdentifyLanguage</code> and want to use one or more vocabulary filters with your
     *        transcription, use the <code>VocabularyFilterNames</code> parameter instead.
     */

    public void setVocabularyFilterName(String vocabularyFilterName) {
        this.vocabularyFilterName = vocabularyFilterName;
    }

    /**
     * <p>
     * Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note
     * that vocabulary filter names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in
     * each Region.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code> and want to use one or more vocabulary filters with your
     * transcription, use the <code>VocabularyFilterNames</code> parameter instead.
     * </p>
     * 
     * @return Specify the name of the custom vocabulary filter that you want to use when processing your transcription.
     *         Note that vocabulary filter names are case sensitive. </p>
     *         <p>
     *         If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon
     *         Transcribe in each Region.
     *         </p>
     *         <p>
     *         If you include <code>IdentifyLanguage</code> and want to use one or more vocabulary filters with your
     *         transcription, use the <code>VocabularyFilterNames</code> parameter instead.
     */

    public String getVocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    /**
     * <p>
     * Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note
     * that vocabulary filter names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in
     * each Region.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code> and want to use one or more vocabulary filters with your
     * transcription, use the <code>VocabularyFilterNames</code> parameter instead.
     * </p>
     * 
     * @param vocabularyFilterName
     *        Specify the name of the custom vocabulary filter that you want to use when processing your transcription.
     *        Note that vocabulary filter names are case sensitive. </p>
     *        <p>
     *        If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon
     *        Transcribe in each Region.
     *        </p>
     *        <p>
     *        If you include <code>IdentifyLanguage</code> and want to use one or more vocabulary filters with your
     *        transcription, use the <code>VocabularyFilterNames</code> parameter instead.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EngineTranscribeSettings withVocabularyFilterName(String vocabularyFilterName) {
        setVocabularyFilterName(vocabularyFilterName);
        return this;
    }

    /**
     * <p>
     * Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe multiple Regions, the vocabulary must be available in Amazon Transcribe in each
     * Region.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code> and want to use one or more custom vocabularies with your
     * transcription, use the <code>VocabularyNames</code> parameter instead.
     * </p>
     * 
     * @param vocabularyName
     *        Specify the name of the custom vocabulary that you want to use when processing your transcription. Note
     *        that vocabulary names are case sensitive.</p>
     *        <p>
     *        If you use Amazon Transcribe multiple Regions, the vocabulary must be available in Amazon Transcribe in
     *        each Region.
     *        </p>
     *        <p>
     *        If you include <code>IdentifyLanguage</code> and want to use one or more custom vocabularies with your
     *        transcription, use the <code>VocabularyNames</code> parameter instead.
     */

    public void setVocabularyName(String vocabularyName) {
        this.vocabularyName = vocabularyName;
    }

    /**
     * <p>
     * Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe multiple Regions, the vocabulary must be available in Amazon Transcribe in each
     * Region.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code> and want to use one or more custom vocabularies with your
     * transcription, use the <code>VocabularyNames</code> parameter instead.
     * </p>
     * 
     * @return Specify the name of the custom vocabulary that you want to use when processing your transcription. Note
     *         that vocabulary names are case sensitive.</p>
     *         <p>
     *         If you use Amazon Transcribe multiple Regions, the vocabulary must be available in Amazon Transcribe in
     *         each Region.
     *         </p>
     *         <p>
     *         If you include <code>IdentifyLanguage</code> and want to use one or more custom vocabularies with your
     *         transcription, use the <code>VocabularyNames</code> parameter instead.
     */

    public String getVocabularyName() {
        return this.vocabularyName;
    }

    /**
     * <p>
     * Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe multiple Regions, the vocabulary must be available in Amazon Transcribe in each
     * Region.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code> and want to use one or more custom vocabularies with your
     * transcription, use the <code>VocabularyNames</code> parameter instead.
     * </p>
     * 
     * @param vocabularyName
     *        Specify the name of the custom vocabulary that you want to use when processing your transcription. Note
     *        that vocabulary names are case sensitive.</p>
     *        <p>
     *        If you use Amazon Transcribe multiple Regions, the vocabulary must be available in Amazon Transcribe in
     *        each Region.
     *        </p>
     *        <p>
     *        If you include <code>IdentifyLanguage</code> and want to use one or more custom vocabularies with your
     *        transcription, use the <code>VocabularyNames</code> parameter instead.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EngineTranscribeSettings withVocabularyName(String vocabularyName) {
        setVocabularyName(vocabularyName);
        return this;
    }

    /**
     * <p>
     * The AWS Region in which to use Amazon Transcribe.
     * </p>
     * <p>
     * If you don't specify a Region, then the <code>MediaRegion</code> parameter of the <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html"
     * >CreateMeeting.html</a> API will be used. However, if Amazon Transcribe is not available in the
     * <code>MediaRegion</code>, then a TranscriptFailed event is sent.
     * </p>
     * <p>
     * Use <code>auto</code> to use Amazon Transcribe in a Region near the meeting’s <code>MediaRegion</code>. For more
     * information, refer to <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region">Choosing a
     * transcription Region</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     * 
     * @param region
     *        The AWS Region in which to use Amazon Transcribe.</p>
     *        <p>
     *        If you don't specify a Region, then the <code>MediaRegion</code> parameter of the <a
     *        href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html"
     *        >CreateMeeting.html</a> API will be used. However, if Amazon Transcribe is not available in the
     *        <code>MediaRegion</code>, then a TranscriptFailed event is sent.
     *        </p>
     *        <p>
     *        Use <code>auto</code> to use Amazon Transcribe in a Region near the meeting’s <code>MediaRegion</code>.
     *        For more information, refer to <a
     *        href="https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region">Choosing a
     *        transcription Region</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * @see TranscribeRegion
     */

    public void setRegion(String region) {
        this.region = region;
    }

    /**
     * <p>
     * The AWS Region in which to use Amazon Transcribe.
     * </p>
     * <p>
     * If you don't specify a Region, then the <code>MediaRegion</code> parameter of the <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html"
     * >CreateMeeting.html</a> API will be used. However, if Amazon Transcribe is not available in the
     * <code>MediaRegion</code>, then a TranscriptFailed event is sent.
     * </p>
     * <p>
     * Use <code>auto</code> to use Amazon Transcribe in a Region near the meeting’s <code>MediaRegion</code>. For more
     * information, refer to <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region">Choosing a
     * transcription Region</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     * 
     * @return The AWS Region in which to use Amazon Transcribe.</p>
     *         <p>
     *         If you don't specify a Region, then the <code>MediaRegion</code> parameter of the <a
     *         href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html"
     *         >CreateMeeting.html</a> API will be used. However, if Amazon Transcribe is not available in the
     *         <code>MediaRegion</code>, then a TranscriptFailed event is sent.
     *         </p>
     *         <p>
     *         Use <code>auto</code> to use Amazon Transcribe in a Region near the meeting’s <code>MediaRegion</code>.
     *         For more information, refer to <a
     *         href="https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region">Choosing
     *         a transcription Region</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * @see TranscribeRegion
     */

    public String getRegion() {
        return this.region;
    }

    /**
     * <p>
     * The AWS Region in which to use Amazon Transcribe.
     * </p>
     * <p>
     * If you don't specify a Region, then the <code>MediaRegion</code> parameter of the <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html"
     * >CreateMeeting.html</a> API will be used. However, if Amazon Transcribe is not available in the
     * <code>MediaRegion</code>, then a TranscriptFailed event is sent.
     * </p>
     * <p>
     * Use <code>auto</code> to use Amazon Transcribe in a Region near the meeting’s <code>MediaRegion</code>. For more
     * information, refer to <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region">Choosing a
     * transcription Region</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     * 
     * @param region
     *        The AWS Region in which to use Amazon Transcribe.</p>
     *        <p>
     *        If you don't specify a Region, then the <code>MediaRegion</code> parameter of the <a
     *        href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html"
     *        >CreateMeeting.html</a> API will be used. However, if Amazon Transcribe is not available in the
     *        <code>MediaRegion</code>, then a TranscriptFailed event is sent.
     *        </p>
     *        <p>
     *        Use <code>auto</code> to use Amazon Transcribe in a Region near the meeting’s <code>MediaRegion</code>.
     *        For more information, refer to <a
     *        href="https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region">Choosing a
     *        transcription Region</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeRegion
     */

    public EngineTranscribeSettings withRegion(String region) {
        setRegion(region);
        return this;
    }

    /**
     * <p>
     * The AWS Region in which to use Amazon Transcribe.
     * </p>
     * <p>
     * If you don't specify a Region, then the <code>MediaRegion</code> parameter of the <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html"
     * >CreateMeeting.html</a> API will be used. However, if Amazon Transcribe is not available in the
     * <code>MediaRegion</code>, then a TranscriptFailed event is sent.
     * </p>
     * <p>
     * Use <code>auto</code> to use Amazon Transcribe in a Region near the meeting’s <code>MediaRegion</code>. For more
     * information, refer to <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region">Choosing a
     * transcription Region</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     * 
     * @param region
     *        The AWS Region in which to use Amazon Transcribe.</p>
     *        <p>
     *        If you don't specify a Region, then the <code>MediaRegion</code> parameter of the <a
     *        href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html"
     *        >CreateMeeting.html</a> API will be used. However, if Amazon Transcribe is not available in the
     *        <code>MediaRegion</code>, then a TranscriptFailed event is sent.
     *        </p>
     *        <p>
     *        Use <code>auto</code> to use Amazon Transcribe in a Region near the meeting’s <code>MediaRegion</code>.
     *        For more information, refer to <a
     *        href="https://docs.aws.amazon.com/chime-sdk/latest/dg/transcription-options.html#choose-region">Choosing a
     *        transcription Region</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeRegion
     */

    public EngineTranscribeSettings withRegion(TranscribeRegion region) {
        this.region = region.toString();
        return this;
    }

    /**
     * <p>
     * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in
     * your output, but may impact accuracy.
     * </p>
     * 
     * @param enablePartialResultsStabilization
     *        Enables partial result stabilization for your transcription. Partial result stabilization can reduce
     *        latency in your output, but may impact accuracy.
     */

    public void setEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
        this.enablePartialResultsStabilization = enablePartialResultsStabilization;
    }

    /**
     * <p>
     * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in
     * your output, but may impact accuracy.
     * </p>
     * 
     * @return Enables partial result stabilization for your transcription. Partial result stabilization can reduce
     *         latency in your output, but may impact accuracy.
     */

    public Boolean getEnablePartialResultsStabilization() {
        return this.enablePartialResultsStabilization;
    }

    /**
     * <p>
     * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in
     * your output, but may impact accuracy.
     * </p>
     * 
     * @param enablePartialResultsStabilization
     *        Enables partial result stabilization for your transcription. Partial result stabilization can reduce
     *        latency in your output, but may impact accuracy.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EngineTranscribeSettings withEnablePartialResultsStabilization(Boolean enablePartialResultsStabilization) {
        setEnablePartialResultsStabilization(enablePartialResultsStabilization);
        return this;
    }

    /**
     * <p>
     * Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in
     * your output, but may impact accuracy.
     * </p>
     * 
     * @return Enables partial result stabilization for your transcription. Partial result stabilization can reduce
     *         latency in your output, but may impact accuracy.
     */

    public Boolean isEnablePartialResultsStabilization() {
        return this.enablePartialResultsStabilization;
    }

    /**
     * <p>
     * Specify the level of stability to use when you enable partial results stabilization (
     * <code>EnablePartialResultsStabilization</code>).
     * </p>
     * <p>
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     * </p>
     * 
     * @param partialResultsStability
     *        Specify the level of stability to use when you enable partial results stabilization (
     *        <code>EnablePartialResultsStabilization</code>).</p>
     *        <p>
     *        Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
     *        accuracy.
     * @see TranscribePartialResultsStability
     */

    public void setPartialResultsStability(String partialResultsStability) {
        this.partialResultsStability = partialResultsStability;
    }

    /**
     * <p>
     * Specify the level of stability to use when you enable partial results stabilization (
     * <code>EnablePartialResultsStabilization</code>).
     * </p>
     * <p>
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     * </p>
     * 
     * @return Specify the level of stability to use when you enable partial results stabilization (
     *         <code>EnablePartialResultsStabilization</code>).</p>
     *         <p>
     *         Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
     *         accuracy.
     * @see TranscribePartialResultsStability
     */

    public String getPartialResultsStability() {
        return this.partialResultsStability;
    }

    /**
     * <p>
     * Specify the level of stability to use when you enable partial results stabilization (
     * <code>EnablePartialResultsStabilization</code>).
     * </p>
     * <p>
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     * </p>
     * 
     * @param partialResultsStability
     *        Specify the level of stability to use when you enable partial results stabilization (
     *        <code>EnablePartialResultsStabilization</code>).</p>
     *        <p>
     *        Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
     *        accuracy.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribePartialResultsStability
     */

    public EngineTranscribeSettings withPartialResultsStability(String partialResultsStability) {
        setPartialResultsStability(partialResultsStability);
        return this;
    }

    /**
     * <p>
     * Specify the level of stability to use when you enable partial results stabilization (
     * <code>EnablePartialResultsStabilization</code>).
     * </p>
     * <p>
     * Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.
     * </p>
     * 
     * @param partialResultsStability
     *        Specify the level of stability to use when you enable partial results stabilization (
     *        <code>EnablePartialResultsStabilization</code>).</p>
     *        <p>
     *        Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower
     *        accuracy.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribePartialResultsStability
     */

    public EngineTranscribeSettings withPartialResultsStability(TranscribePartialResultsStability partialResultsStability) {
        this.partialResultsStability = partialResultsStability.toString();
        return this;
    }

    /**
     * <p>
     * Labels all personally identifiable information (PII) identified in your transcript. If you don't include
     * <code>PiiEntityTypes</code>, all PII is identified.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * </p>
     * 
     * @param contentIdentificationType
     *        Labels all personally identifiable information (PII) identified in your transcript. If you don't include
     *        <code>PiiEntityTypes</code>, all PII is identified.</p>
     *        <p>
     *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * @see TranscribeContentIdentificationType
     */

    public void setContentIdentificationType(String contentIdentificationType) {
        this.contentIdentificationType = contentIdentificationType;
    }

    /**
     * <p>
     * Labels all personally identifiable information (PII) identified in your transcript. If you don't include
     * <code>PiiEntityTypes</code>, all PII is identified.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * </p>
     * 
     * @return Labels all personally identifiable information (PII) identified in your transcript. If you don't include
     *         <code>PiiEntityTypes</code>, all PII is identified.</p>
     *         <p>
     *         You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * @see TranscribeContentIdentificationType
     */

    public String getContentIdentificationType() {
        return this.contentIdentificationType;
    }

    /**
     * <p>
     * Labels all personally identifiable information (PII) identified in your transcript. If you don't include
     * <code>PiiEntityTypes</code>, all PII is identified.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * </p>
     * 
     * @param contentIdentificationType
     *        Labels all personally identifiable information (PII) identified in your transcript. If you don't include
     *        <code>PiiEntityTypes</code>, all PII is identified.</p>
     *        <p>
     *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeContentIdentificationType
     */

    public EngineTranscribeSettings withContentIdentificationType(String contentIdentificationType) {
        setContentIdentificationType(contentIdentificationType);
        return this;
    }

    /**
     * <p>
     * Labels all personally identifiable information (PII) identified in your transcript. If you don't include
     * <code>PiiEntityTypes</code>, all PII is identified.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * </p>
     * 
     * @param contentIdentificationType
     *        Labels all personally identifiable information (PII) identified in your transcript. If you don't include
     *        <code>PiiEntityTypes</code>, all PII is identified.</p>
     *        <p>
     *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeContentIdentificationType
     */

    public EngineTranscribeSettings withContentIdentificationType(TranscribeContentIdentificationType contentIdentificationType) {
        this.contentIdentificationType = contentIdentificationType.toString();
        return this;
    }

    /**
     * <p>
     * Content redaction is performed at the segment level. If you don't include <code>PiiEntityTypes</code>, all PII is
     * redacted.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * </p>
     * 
     * @param contentRedactionType
     *        Content redaction is performed at the segment level. If you don't include <code>PiiEntityTypes</code>, all
     *        PII is redacted.</p>
     *        <p>
     *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * @see TranscribeContentRedactionType
     */

    public void setContentRedactionType(String contentRedactionType) {
        this.contentRedactionType = contentRedactionType;
    }

    /**
     * <p>
     * Content redaction is performed at the segment level. If you don't include <code>PiiEntityTypes</code>, all PII is
     * redacted.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * </p>
     * 
     * @return Content redaction is performed at the segment level. If you don't include <code>PiiEntityTypes</code>,
     *         all PII is redacted.</p>
     *         <p>
     *         You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * @see TranscribeContentRedactionType
     */

    public String getContentRedactionType() {
        return this.contentRedactionType;
    }

    /**
     * <p>
     * Content redaction is performed at the segment level. If you don't include <code>PiiEntityTypes</code>, all PII is
     * redacted.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * </p>
     * 
     * @param contentRedactionType
     *        Content redaction is performed at the segment level. If you don't include <code>PiiEntityTypes</code>, all
     *        PII is redacted.</p>
     *        <p>
     *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeContentRedactionType
     */

    public EngineTranscribeSettings withContentRedactionType(String contentRedactionType) {
        setContentRedactionType(contentRedactionType);
        return this;
    }

    /**
     * <p>
     * Content redaction is performed at the segment level. If you don't include <code>PiiEntityTypes</code>, all PII is
     * redacted.
     * </p>
     * <p>
     * You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * </p>
     * 
     * @param contentRedactionType
     *        Content redaction is performed at the segment level. If you don't include <code>PiiEntityTypes</code>, all
     *        PII is redacted.</p>
     *        <p>
     *        You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeContentRedactionType
     */

    public EngineTranscribeSettings withContentRedactionType(TranscribeContentRedactionType contentRedactionType) {
        this.contentRedactionType = contentRedactionType.toString();
        return this;
    }

    /**
     * <p>
     * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can
     * include as many types as you'd like, or you can select <code>ALL</code>.
     * </p>
     * <p>
     * Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
     * <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>
     * <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>,<code>NAME</code>, <code>PHONE</code>, <code>PIN</code>,
     * <code>SSN</code>, or <code>ALL</code>.
     * </p>
     * <p>
     * Note that if you include <code>PiiEntityTypes</code>, you must also include
     * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
     * </p>
     * <p>
     * If you include <code>ContentRedactionType</code> or <code>ContentIdentificationType</code>, but do not include
     * <code>PiiEntityTypes</code>, all PII is redacted or identified.
     * </p>
     * 
     * @param piiEntityTypes
     *        Specify which types of personally identifiable information (PII) you want to redact in your transcript.
     *        You can include as many types as you'd like, or you can select <code>ALL</code>.</p>
     *        <p>
     *        Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
     *        <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>
     *        <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>,<code>NAME</code>, <code>PHONE</code>,
     *        <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.
     *        </p>
     *        <p>
     *        Note that if you include <code>PiiEntityTypes</code>, you must also include
     *        <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
     *        </p>
     *        <p>
     *        If you include <code>ContentRedactionType</code> or <code>ContentIdentificationType</code>, but do not
     *        include <code>PiiEntityTypes</code>, all PII is redacted or identified.
     */

    public void setPiiEntityTypes(String piiEntityTypes) {
        this.piiEntityTypes = piiEntityTypes;
    }

    /**
     * <p>
     * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can
     * include as many types as you'd like, or you can select <code>ALL</code>.
     * </p>
     * <p>
     * Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
     * <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>
     * <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>,<code>NAME</code>, <code>PHONE</code>, <code>PIN</code>,
     * <code>SSN</code>, or <code>ALL</code>.
     * </p>
     * <p>
     * Note that if you include <code>PiiEntityTypes</code>, you must also include
     * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
     * </p>
     * <p>
     * If you include <code>ContentRedactionType</code> or <code>ContentIdentificationType</code>, but do not include
     * <code>PiiEntityTypes</code>, all PII is redacted or identified.
     * </p>
     * 
     * @return Specify which types of personally identifiable information (PII) you want to redact in your transcript.
     *         You can include as many types as you'd like, or you can select <code>ALL</code>.</p>
     *         <p>
     *         Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
     *         <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>
     *         <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>,<code>NAME</code>, <code>PHONE</code>,
     *         <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.
     *         </p>
     *         <p>
     *         Note that if you include <code>PiiEntityTypes</code>, you must also include
     *         <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
     *         </p>
     *         <p>
     *         If you include <code>ContentRedactionType</code> or <code>ContentIdentificationType</code>, but do not
     *         include <code>PiiEntityTypes</code>, all PII is redacted or identified.
     */

    public String getPiiEntityTypes() {
        return this.piiEntityTypes;
    }

    /**
     * <p>
     * Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can
     * include as many types as you'd like, or you can select <code>ALL</code>.
     * </p>
     * <p>
     * Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
     * <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>
     * <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>,<code>NAME</code>, <code>PHONE</code>, <code>PIN</code>,
     * <code>SSN</code>, or <code>ALL</code>.
     * </p>
     * <p>
     * Note that if you include <code>PiiEntityTypes</code>, you must also include
     * <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
     * </p>
     * <p>
     * If you include <code>ContentRedactionType</code> or <code>ContentIdentificationType</code>, but do not include
     * <code>PiiEntityTypes</code>, all PII is redacted or identified.
     * </p>
     * 
     * @param piiEntityTypes
     *        Specify which types of personally identifiable information (PII) you want to redact in your transcript.
     *        You can include as many types as you'd like, or you can select <code>ALL</code>.</p>
     *        <p>
     *        Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>,
     *        <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>
     *        <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>,<code>NAME</code>, <code>PHONE</code>,
     *        <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.
     *        </p>
     *        <p>
     *        Note that if you include <code>PiiEntityTypes</code>, you must also include
     *        <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.
     *        </p>
     *        <p>
     *        If you include <code>ContentRedactionType</code> or <code>ContentIdentificationType</code>, but do not
     *        include <code>PiiEntityTypes</code>, all PII is redacted or identified.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EngineTranscribeSettings withPiiEntityTypes(String piiEntityTypes) {
        setPiiEntityTypes(piiEntityTypes);
        return this;
    }

    /**
     * <p>
     * Specify the name of the custom language model that you want to use when processing your transcription. Note that
     * language model names are case sensitive.
     * </p>
     * <p>
     * The language of the specified language model must match the language code. If the languages don't match, the
     * custom language model isn't applied. There are no errors or warnings associated with a language mismatch.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the custom language model must be available in Amazon
     * Transcribe in each Region.
     * </p>
     * 
     * @param languageModelName
     *        Specify the name of the custom language model that you want to use when processing your transcription.
     *        Note that language model names are case sensitive.</p>
     *        <p>
     *        The language of the specified language model must match the language code. If the languages don't match,
     *        the custom language model isn't applied. There are no errors or warnings associated with a language
     *        mismatch.
     *        </p>
     *        <p>
     *        If you use Amazon Transcribe in multiple Regions, the custom language model must be available in Amazon
     *        Transcribe in each Region.
     */

    public void setLanguageModelName(String languageModelName) {
        this.languageModelName = languageModelName;
    }

    /**
     * <p>
     * Specify the name of the custom language model that you want to use when processing your transcription. Note that
     * language model names are case sensitive.
     * </p>
     * <p>
     * The language of the specified language model must match the language code. If the languages don't match, the
     * custom language model isn't applied. There are no errors or warnings associated with a language mismatch.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the custom language model must be available in Amazon
     * Transcribe in each Region.
     * </p>
     * 
     * @return Specify the name of the custom language model that you want to use when processing your transcription.
     *         Note that language model names are case sensitive.</p>
     *         <p>
     *         The language of the specified language model must match the language code. If the languages don't match,
     *         the custom language model isn't applied. There are no errors or warnings associated with a language
     *         mismatch.
     *         </p>
     *         <p>
     *         If you use Amazon Transcribe in multiple Regions, the custom language model must be available in Amazon
     *         Transcribe in each Region.
     */

    public String getLanguageModelName() {
        return this.languageModelName;
    }

    /**
     * <p>
     * Specify the name of the custom language model that you want to use when processing your transcription. Note that
     * language model names are case sensitive.
     * </p>
     * <p>
     * The language of the specified language model must match the language code. If the languages don't match, the
     * custom language model isn't applied. There are no errors or warnings associated with a language mismatch.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the custom language model must be available in Amazon
     * Transcribe in each Region.
     * </p>
     * 
     * @param languageModelName
     *        Specify the name of the custom language model that you want to use when processing your transcription.
     *        Note that language model names are case sensitive.</p>
     *        <p>
     *        The language of the specified language model must match the language code. If the languages don't match,
     *        the custom language model isn't applied. There are no errors or warnings associated with a language
     *        mismatch.
     *        </p>
     *        <p>
     *        If you use Amazon Transcribe in multiple Regions, the custom language model must be available in Amazon
     *        Transcribe in each Region.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EngineTranscribeSettings withLanguageModelName(String languageModelName) {
        setLanguageModelName(languageModelName);
        return this;
    }

    /**
     * <p>
     * Enables automatic language identification for your transcription.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code>, you can optionally use <code>LanguageOptions</code> to include a
     * list of language codes that you think may be present in your audio stream. Including language options can improve
     * transcription accuracy.
     * </p>
     * <p>
     * You can also use <code>PreferredLanguage</code> to include a preferred language. Doing so can help Amazon
     * Transcribe identify the language faster.
     * </p>
     * <p>
     * You must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code>.
     * </p>
     * <p>
     * Language identification can't be combined with custom language models or redaction.
     * </p>
     * 
     * @param identifyLanguage
     *        Enables automatic language identification for your transcription.</p>
     *        <p>
     *        If you include <code>IdentifyLanguage</code>, you can optionally use <code>LanguageOptions</code> to
     *        include a list of language codes that you think may be present in your audio stream. Including language
     *        options can improve transcription accuracy.
     *        </p>
     *        <p>
     *        You can also use <code>PreferredLanguage</code> to include a preferred language. Doing so can help Amazon
     *        Transcribe identify the language faster.
     *        </p>
     *        <p>
     *        You must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code>.
     *        </p>
     *        <p>
     *        Language identification can't be combined with custom language models or redaction.
     */

    public void setIdentifyLanguage(Boolean identifyLanguage) {
        this.identifyLanguage = identifyLanguage;
    }

    /**
     * <p>
     * Enables automatic language identification for your transcription.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code>, you can optionally use <code>LanguageOptions</code> to include a
     * list of language codes that you think may be present in your audio stream. Including language options can improve
     * transcription accuracy.
     * </p>
     * <p>
     * You can also use <code>PreferredLanguage</code> to include a preferred language. Doing so can help Amazon
     * Transcribe identify the language faster.
     * </p>
     * <p>
     * You must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code>.
     * </p>
     * <p>
     * Language identification can't be combined with custom language models or redaction.
     * </p>
     * 
     * @return Enables automatic language identification for your transcription.</p>
     *         <p>
     *         If you include <code>IdentifyLanguage</code>, you can optionally use <code>LanguageOptions</code> to
     *         include a list of language codes that you think may be present in your audio stream. Including language
     *         options can improve transcription accuracy.
     *         </p>
     *         <p>
     *         You can also use <code>PreferredLanguage</code> to include a preferred language. Doing so can help Amazon
     *         Transcribe identify the language faster.
     *         </p>
     *         <p>
     *         You must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code>.
     *         </p>
     *         <p>
     *         Language identification can't be combined with custom language models or redaction.
     */

    public Boolean getIdentifyLanguage() {
        return this.identifyLanguage;
    }

    /**
     * <p>
     * Enables automatic language identification for your transcription.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code>, you can optionally use <code>LanguageOptions</code> to include a
     * list of language codes that you think may be present in your audio stream. Including language options can improve
     * transcription accuracy.
     * </p>
     * <p>
     * You can also use <code>PreferredLanguage</code> to include a preferred language. Doing so can help Amazon
     * Transcribe identify the language faster.
     * </p>
     * <p>
     * You must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code>.
     * </p>
     * <p>
     * Language identification can't be combined with custom language models or redaction.
     * </p>
     * 
     * @param identifyLanguage
     *        Enables automatic language identification for your transcription.</p>
     *        <p>
     *        If you include <code>IdentifyLanguage</code>, you can optionally use <code>LanguageOptions</code> to
     *        include a list of language codes that you think may be present in your audio stream. Including language
     *        options can improve transcription accuracy.
     *        </p>
     *        <p>
     *        You can also use <code>PreferredLanguage</code> to include a preferred language. Doing so can help Amazon
     *        Transcribe identify the language faster.
     *        </p>
     *        <p>
     *        You must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code>.
     *        </p>
     *        <p>
     *        Language identification can't be combined with custom language models or redaction.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EngineTranscribeSettings withIdentifyLanguage(Boolean identifyLanguage) {
        setIdentifyLanguage(identifyLanguage);
        return this;
    }

    /**
     * <p>
     * Enables automatic language identification for your transcription.
     * </p>
     * <p>
     * If you include <code>IdentifyLanguage</code>, you can optionally use <code>LanguageOptions</code> to include a
     * list of language codes that you think may be present in your audio stream. Including language options can improve
     * transcription accuracy.
     * </p>
     * <p>
     * You can also use <code>PreferredLanguage</code> to include a preferred language. Doing so can help Amazon
     * Transcribe identify the language faster.
     * </p>
     * <p>
     * You must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code>.
     * </p>
     * <p>
     * Language identification can't be combined with custom language models or redaction.
     * </p>
     * 
     * @return Enables automatic language identification for your transcription.</p>
     *         <p>
     *         If you include <code>IdentifyLanguage</code>, you can optionally use <code>LanguageOptions</code> to
     *         include a list of language codes that you think may be present in your audio stream. Including language
     *         options can improve transcription accuracy.
     *         </p>
     *         <p>
     *         You can also use <code>PreferredLanguage</code> to include a preferred language. Doing so can help Amazon
     *         Transcribe identify the language faster.
     *         </p>
     *         <p>
     *         You must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code>.
     *         </p>
     *         <p>
     *         Language identification can't be combined with custom language models or redaction.
     */

    public Boolean isIdentifyLanguage() {
        return this.identifyLanguage;
    }

    /**
     * <p>
     * Specify two or more language codes that represent the languages you think may be present in your media; including
     * more than five is not recommended. If you're unsure what languages are present, do not include this parameter.
     * </p>
     * <p>
     * Including language options can improve the accuracy of language identification.
     * </p>
     * <p>
     * If you include <code>LanguageOptions</code>, you must also include <code>IdentifyLanguage</code>.
     * </p>
     * <important>
     * <p>
     * You can only include one language dialect per language. For example, you cannot include <code>en-US</code> and
     * <code>en-AU</code>.
     * </p>
     * </important>
     * 
     * @param languageOptions
     *        Specify two or more language codes that represent the languages you think may be present in your media;
     *        including more than five is not recommended. If you're unsure what languages are present, do not include
     *        this parameter.</p>
     *        <p>
     *        Including language options can improve the accuracy of language identification.
     *        </p>
     *        <p>
     *        If you include <code>LanguageOptions</code>, you must also include <code>IdentifyLanguage</code>.
     *        </p>
     *        <important>
     *        <p>
     *        You can only include one language dialect per language. For example, you cannot include <code>en-US</code>
     *        and <code>en-AU</code>.
     *        </p>
     */

    public void setLanguageOptions(String languageOptions) {
        this.languageOptions = languageOptions;
    }

    /**
     * <p>
     * Specify two or more language codes that represent the languages you think may be present in your media; including
     * more than five is not recommended. If you're unsure what languages are present, do not include this parameter.
     * </p>
     * <p>
     * Including language options can improve the accuracy of language identification.
     * </p>
     * <p>
     * If you include <code>LanguageOptions</code>, you must also include <code>IdentifyLanguage</code>.
     * </p>
     * <important>
     * <p>
     * You can only include one language dialect per language. For example, you cannot include <code>en-US</code> and
     * <code>en-AU</code>.
     * </p>
     * </important>
     * 
     * @return Specify two or more language codes that represent the languages you think may be present in your media;
     *         including more than five is not recommended. If you're unsure what languages are present, do not include
     *         this parameter.</p>
     *         <p>
     *         Including language options can improve the accuracy of language identification.
     *         </p>
     *         <p>
     *         If you include <code>LanguageOptions</code>, you must also include <code>IdentifyLanguage</code>.
     *         </p>
     *         <important>
     *         <p>
     *         You can only include one language dialect per language. For example, you cannot include
     *         <code>en-US</code> and <code>en-AU</code>.
     *         </p>
     */

    public String getLanguageOptions() {
        return this.languageOptions;
    }

    /**
     * <p>
     * Specify two or more language codes that represent the languages you think may be present in your media; including
     * more than five is not recommended. If you're unsure what languages are present, do not include this parameter.
     * </p>
     * <p>
     * Including language options can improve the accuracy of language identification.
     * </p>
     * <p>
     * If you include <code>LanguageOptions</code>, you must also include <code>IdentifyLanguage</code>.
     * </p>
     * <important>
     * <p>
     * You can only include one language dialect per language. For example, you cannot include <code>en-US</code> and
     * <code>en-AU</code>.
     * </p>
     * </important>
     * 
     * @param languageOptions
     *        Specify two or more language codes that represent the languages you think may be present in your media;
     *        including more than five is not recommended. If you're unsure what languages are present, do not include
     *        this parameter.</p>
     *        <p>
     *        Including language options can improve the accuracy of language identification.
     *        </p>
     *        <p>
     *        If you include <code>LanguageOptions</code>, you must also include <code>IdentifyLanguage</code>.
     *        </p>
     *        <important>
     *        <p>
     *        You can only include one language dialect per language. For example, you cannot include <code>en-US</code>
     *        and <code>en-AU</code>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EngineTranscribeSettings withLanguageOptions(String languageOptions) {
        setLanguageOptions(languageOptions);
        return this;
    }

    /**
     * <p>
     * Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.
     * </p>
     * <p>
     * You can only use this parameter if you include <code>IdentifyLanguage</code> and <code>LanguageOptions</code>.
     * </p>
     * 
     * @param preferredLanguage
     *        Specify a preferred language from the subset of languages codes you specified in
     *        <code>LanguageOptions</code>.</p>
     *        <p>
     *        You can only use this parameter if you include <code>IdentifyLanguage</code> and
     *        <code>LanguageOptions</code>.
     * @see TranscribeLanguageCode
     */

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    /**
     * <p>
     * Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.
     * </p>
     * <p>
     * You can only use this parameter if you include <code>IdentifyLanguage</code> and <code>LanguageOptions</code>.
     * </p>
     * 
     * @return Specify a preferred language from the subset of languages codes you specified in
     *         <code>LanguageOptions</code>.</p>
     *         <p>
     *         You can only use this parameter if you include <code>IdentifyLanguage</code> and
     *         <code>LanguageOptions</code>.
     * @see TranscribeLanguageCode
     */

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    /**
     * <p>
     * Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.
     * </p>
     * <p>
     * You can only use this parameter if you include <code>IdentifyLanguage</code> and <code>LanguageOptions</code>.
     * </p>
     * 
     * @param preferredLanguage
     *        Specify a preferred language from the subset of languages codes you specified in
     *        <code>LanguageOptions</code>.</p>
     *        <p>
     *        You can only use this parameter if you include <code>IdentifyLanguage</code> and
     *        <code>LanguageOptions</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeLanguageCode
     */

    public EngineTranscribeSettings withPreferredLanguage(String preferredLanguage) {
        setPreferredLanguage(preferredLanguage);
        return this;
    }

    /**
     * <p>
     * Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.
     * </p>
     * <p>
     * You can only use this parameter if you include <code>IdentifyLanguage</code> and <code>LanguageOptions</code>.
     * </p>
     * 
     * @param preferredLanguage
     *        Specify a preferred language from the subset of languages codes you specified in
     *        <code>LanguageOptions</code>.</p>
     *        <p>
     *        You can only use this parameter if you include <code>IdentifyLanguage</code> and
     *        <code>LanguageOptions</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TranscribeLanguageCode
     */

    public EngineTranscribeSettings withPreferredLanguage(TranscribeLanguageCode preferredLanguage) {
        this.preferredLanguage = preferredLanguage.toString();
        return this;
    }

    /**
     * <p>
     * Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary must be available in Amazon Transcribe in each
     * Region.
     * </p>
     * <p>
     * If you don't include <code>IdentifyLanguage</code> and want to use a custom vocabulary with your transcription,
     * use the <code>VocabularyName</code> parameter instead.
     * </p>
     * 
     * @param vocabularyNames
     *        Specify the names of the custom vocabularies that you want to use when processing your transcription. Note
     *        that vocabulary names are case sensitive.</p>
     *        <p>
     *        If you use Amazon Transcribe in multiple Regions, the vocabulary must be available in Amazon Transcribe in
     *        each Region.
     *        </p>
     *        <p>
     *        If you don't include <code>IdentifyLanguage</code> and want to use a custom vocabulary with your
     *        transcription, use the <code>VocabularyName</code> parameter instead.
     */

    public void setVocabularyNames(String vocabularyNames) {
        this.vocabularyNames = vocabularyNames;
    }

    /**
     * <p>
     * Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary must be available in Amazon Transcribe in each
     * Region.
     * </p>
     * <p>
     * If you don't include <code>IdentifyLanguage</code> and want to use a custom vocabulary with your transcription,
     * use the <code>VocabularyName</code> parameter instead.
     * </p>
     * 
     * @return Specify the names of the custom vocabularies that you want to use when processing your transcription.
     *         Note that vocabulary names are case sensitive.</p>
     *         <p>
     *         If you use Amazon Transcribe in multiple Regions, the vocabulary must be available in Amazon Transcribe
     *         in each Region.
     *         </p>
     *         <p>
     *         If you don't include <code>IdentifyLanguage</code> and want to use a custom vocabulary with your
     *         transcription, use the <code>VocabularyName</code> parameter instead.
     */

    public String getVocabularyNames() {
        return this.vocabularyNames;
    }

    /**
     * <p>
     * Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary must be available in Amazon Transcribe in each
     * Region.
     * </p>
     * <p>
     * If you don't include <code>IdentifyLanguage</code> and want to use a custom vocabulary with your transcription,
     * use the <code>VocabularyName</code> parameter instead.
     * </p>
     * 
     * @param vocabularyNames
     *        Specify the names of the custom vocabularies that you want to use when processing your transcription. Note
     *        that vocabulary names are case sensitive.</p>
     *        <p>
     *        If you use Amazon Transcribe in multiple Regions, the vocabulary must be available in Amazon Transcribe in
     *        each Region.
     *        </p>
     *        <p>
     *        If you don't include <code>IdentifyLanguage</code> and want to use a custom vocabulary with your
     *        transcription, use the <code>VocabularyName</code> parameter instead.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EngineTranscribeSettings withVocabularyNames(String vocabularyNames) {
        setVocabularyNames(vocabularyNames);
        return this;
    }

    /**
     * <p>
     * Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note
     * that vocabulary filter names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in
     * each Region.
     * </p>
     * <p>
     * If you're <i>not</i> including <code>IdentifyLanguage</code> and want to use a custom vocabulary filter with your
     * transcription, use the <code>VocabularyFilterName</code> parameter instead.
     * </p>
     * 
     * @param vocabularyFilterNames
     *        Specify the names of the custom vocabulary filters that you want to use when processing your
     *        transcription. Note that vocabulary filter names are case sensitive.</p>
     *        <p>
     *        If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon
     *        Transcribe in each Region.
     *        </p>
     *        <p>
     *        If you're <i>not</i> including <code>IdentifyLanguage</code> and want to use a custom vocabulary filter
     *        with your transcription, use the <code>VocabularyFilterName</code> parameter instead.
     */

    public void setVocabularyFilterNames(String vocabularyFilterNames) {
        this.vocabularyFilterNames = vocabularyFilterNames;
    }

    /**
     * <p>
     * Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note
     * that vocabulary filter names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in
     * each Region.
     * </p>
     * <p>
     * If you're <i>not</i> including <code>IdentifyLanguage</code> and want to use a custom vocabulary filter with your
     * transcription, use the <code>VocabularyFilterName</code> parameter instead.
     * </p>
     * 
     * @return Specify the names of the custom vocabulary filters that you want to use when processing your
     *         transcription. Note that vocabulary filter names are case sensitive.</p>
     *         <p>
     *         If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon
     *         Transcribe in each Region.
     *         </p>
     *         <p>
     *         If you're <i>not</i> including <code>IdentifyLanguage</code> and want to use a custom vocabulary filter
     *         with your transcription, use the <code>VocabularyFilterName</code> parameter instead.
     */

    public String getVocabularyFilterNames() {
        return this.vocabularyFilterNames;
    }

    /**
     * <p>
     * Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note
     * that vocabulary filter names are case sensitive.
     * </p>
     * <p>
     * If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon Transcribe in
     * each Region.
     * </p>
     * <p>
     * If you're <i>not</i> including <code>IdentifyLanguage</code> and want to use a custom vocabulary filter with your
     * transcription, use the <code>VocabularyFilterName</code> parameter instead.
     * </p>
     * 
     * @param vocabularyFilterNames
     *        Specify the names of the custom vocabulary filters that you want to use when processing your
     *        transcription. Note that vocabulary filter names are case sensitive.</p>
     *        <p>
     *        If you use Amazon Transcribe in multiple Regions, the vocabulary filter must be available in Amazon
     *        Transcribe in each Region.
     *        </p>
     *        <p>
     *        If you're <i>not</i> including <code>IdentifyLanguage</code> and want to use a custom vocabulary filter
     *        with your transcription, use the <code>VocabularyFilterName</code> parameter instead.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EngineTranscribeSettings withVocabularyFilterNames(String vocabularyFilterNames) {
        setVocabularyFilterNames(vocabularyFilterNames);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLanguageCode() != null)
            sb.append("LanguageCode: ").append(getLanguageCode()).append(",");
        if (getVocabularyFilterMethod() != null)
            sb.append("VocabularyFilterMethod: ").append(getVocabularyFilterMethod()).append(",");
        if (getVocabularyFilterName() != null)
            sb.append("VocabularyFilterName: ").append(getVocabularyFilterName()).append(",");
        if (getVocabularyName() != null)
            sb.append("VocabularyName: ").append(getVocabularyName()).append(",");
        if (getRegion() != null)
            sb.append("Region: ").append(getRegion()).append(",");
        if (getEnablePartialResultsStabilization() != null)
            sb.append("EnablePartialResultsStabilization: ").append(getEnablePartialResultsStabilization()).append(",");
        if (getPartialResultsStability() != null)
            sb.append("PartialResultsStability: ").append(getPartialResultsStability()).append(",");
        if (getContentIdentificationType() != null)
            sb.append("ContentIdentificationType: ").append(getContentIdentificationType()).append(",");
        if (getContentRedactionType() != null)
            sb.append("ContentRedactionType: ").append(getContentRedactionType()).append(",");
        if (getPiiEntityTypes() != null)
            sb.append("PiiEntityTypes: ").append(getPiiEntityTypes()).append(",");
        if (getLanguageModelName() != null)
            sb.append("LanguageModelName: ").append(getLanguageModelName()).append(",");
        if (getIdentifyLanguage() != null)
            sb.append("IdentifyLanguage: ").append(getIdentifyLanguage()).append(",");
        if (getLanguageOptions() != null)
            sb.append("LanguageOptions: ").append(getLanguageOptions()).append(",");
        if (getPreferredLanguage() != null)
            sb.append("PreferredLanguage: ").append(getPreferredLanguage()).append(",");
        if (getVocabularyNames() != null)
            sb.append("VocabularyNames: ").append(getVocabularyNames()).append(",");
        if (getVocabularyFilterNames() != null)
            sb.append("VocabularyFilterNames: ").append(getVocabularyFilterNames());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof EngineTranscribeSettings == false)
            return false;
        EngineTranscribeSettings other = (EngineTranscribeSettings) obj;
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null)
            return false;
        if (other.getLanguageCode() != null && other.getLanguageCode().equals(this.getLanguageCode()) == false)
            return false;
        if (other.getVocabularyFilterMethod() == null ^ this.getVocabularyFilterMethod() == null)
            return false;
        if (other.getVocabularyFilterMethod() != null && other.getVocabularyFilterMethod().equals(this.getVocabularyFilterMethod()) == false)
            return false;
        if (other.getVocabularyFilterName() == null ^ this.getVocabularyFilterName() == null)
            return false;
        if (other.getVocabularyFilterName() != null && other.getVocabularyFilterName().equals(this.getVocabularyFilterName()) == false)
            return false;
        if (other.getVocabularyName() == null ^ this.getVocabularyName() == null)
            return false;
        if (other.getVocabularyName() != null && other.getVocabularyName().equals(this.getVocabularyName()) == false)
            return false;
        if (other.getRegion() == null ^ this.getRegion() == null)
            return false;
        if (other.getRegion() != null && other.getRegion().equals(this.getRegion()) == false)
            return false;
        if (other.getEnablePartialResultsStabilization() == null ^ this.getEnablePartialResultsStabilization() == null)
            return false;
        if (other.getEnablePartialResultsStabilization() != null
                && other.getEnablePartialResultsStabilization().equals(this.getEnablePartialResultsStabilization()) == false)
            return false;
        if (other.getPartialResultsStability() == null ^ this.getPartialResultsStability() == null)
            return false;
        if (other.getPartialResultsStability() != null && other.getPartialResultsStability().equals(this.getPartialResultsStability()) == false)
            return false;
        if (other.getContentIdentificationType() == null ^ this.getContentIdentificationType() == null)
            return false;
        if (other.getContentIdentificationType() != null && other.getContentIdentificationType().equals(this.getContentIdentificationType()) == false)
            return false;
        if (other.getContentRedactionType() == null ^ this.getContentRedactionType() == null)
            return false;
        if (other.getContentRedactionType() != null && other.getContentRedactionType().equals(this.getContentRedactionType()) == false)
            return false;
        if (other.getPiiEntityTypes() == null ^ this.getPiiEntityTypes() == null)
            return false;
        if (other.getPiiEntityTypes() != null && other.getPiiEntityTypes().equals(this.getPiiEntityTypes()) == false)
            return false;
        if (other.getLanguageModelName() == null ^ this.getLanguageModelName() == null)
            return false;
        if (other.getLanguageModelName() != null && other.getLanguageModelName().equals(this.getLanguageModelName()) == false)
            return false;
        if (other.getIdentifyLanguage() == null ^ this.getIdentifyLanguage() == null)
            return false;
        if (other.getIdentifyLanguage() != null && other.getIdentifyLanguage().equals(this.getIdentifyLanguage()) == false)
            return false;
        if (other.getLanguageOptions() == null ^ this.getLanguageOptions() == null)
            return false;
        if (other.getLanguageOptions() != null && other.getLanguageOptions().equals(this.getLanguageOptions()) == false)
            return false;
        if (other.getPreferredLanguage() == null ^ this.getPreferredLanguage() == null)
            return false;
        if (other.getPreferredLanguage() != null && other.getPreferredLanguage().equals(this.getPreferredLanguage()) == false)
            return false;
        if (other.getVocabularyNames() == null ^ this.getVocabularyNames() == null)
            return false;
        if (other.getVocabularyNames() != null && other.getVocabularyNames().equals(this.getVocabularyNames()) == false)
            return false;
        if (other.getVocabularyFilterNames() == null ^ this.getVocabularyFilterNames() == null)
            return false;
        if (other.getVocabularyFilterNames() != null && other.getVocabularyFilterNames().equals(this.getVocabularyFilterNames()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLanguageCode() == null) ? 0 : getLanguageCode().hashCode());
        hashCode = prime * hashCode + ((getVocabularyFilterMethod() == null) ? 0 : getVocabularyFilterMethod().hashCode());
        hashCode = prime * hashCode + ((getVocabularyFilterName() == null) ? 0 : getVocabularyFilterName().hashCode());
        hashCode = prime * hashCode + ((getVocabularyName() == null) ? 0 : getVocabularyName().hashCode());
        hashCode = prime * hashCode + ((getRegion() == null) ? 0 : getRegion().hashCode());
        hashCode = prime * hashCode + ((getEnablePartialResultsStabilization() == null) ? 0 : getEnablePartialResultsStabilization().hashCode());
        hashCode = prime * hashCode + ((getPartialResultsStability() == null) ? 0 : getPartialResultsStability().hashCode());
        hashCode = prime * hashCode + ((getContentIdentificationType() == null) ? 0 : getContentIdentificationType().hashCode());
        hashCode = prime * hashCode + ((getContentRedactionType() == null) ? 0 : getContentRedactionType().hashCode());
        hashCode = prime * hashCode + ((getPiiEntityTypes() == null) ? 0 : getPiiEntityTypes().hashCode());
        hashCode = prime * hashCode + ((getLanguageModelName() == null) ? 0 : getLanguageModelName().hashCode());
        hashCode = prime * hashCode + ((getIdentifyLanguage() == null) ? 0 : getIdentifyLanguage().hashCode());
        hashCode = prime * hashCode + ((getLanguageOptions() == null) ? 0 : getLanguageOptions().hashCode());
        hashCode = prime * hashCode + ((getPreferredLanguage() == null) ? 0 : getPreferredLanguage().hashCode());
        hashCode = prime * hashCode + ((getVocabularyNames() == null) ? 0 : getVocabularyNames().hashCode());
        hashCode = prime * hashCode + ((getVocabularyFilterNames() == null) ? 0 : getVocabularyFilterNames().hashCode());
        return hashCode;
    }

    @Override
    public EngineTranscribeSettings clone() {
        try {
            return (EngineTranscribeSettings) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.chime.model.transform.EngineTranscribeSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
