/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.billingconductor.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.billingconductor.model.PricingRuleListElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPricingRulesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String billingPeriod;
    private List<PricingRuleListElement> pricingRules;
    private String nextToken;

    public void setBillingPeriod(String billingPeriod) {
        this.billingPeriod = billingPeriod;
    }

    public String getBillingPeriod() {
        return this.billingPeriod;
    }

    public ListPricingRulesResult withBillingPeriod(String billingPeriod) {
        this.setBillingPeriod(billingPeriod);
        return this;
    }

    public List<PricingRuleListElement> getPricingRules() {
        return this.pricingRules;
    }

    public void setPricingRules(Collection<PricingRuleListElement> pricingRules) {
        if (pricingRules == null) {
            this.pricingRules = null;
            return;
        }
        this.pricingRules = new ArrayList<PricingRuleListElement>(pricingRules);
    }

    public ListPricingRulesResult withPricingRules(PricingRuleListElement ... pricingRules) {
        if (this.pricingRules == null) {
            this.setPricingRules(new ArrayList<PricingRuleListElement>(pricingRules.length));
        }
        for (PricingRuleListElement ele : pricingRules) {
            this.pricingRules.add(ele);
        }
        return this;
    }

    public ListPricingRulesResult withPricingRules(Collection<PricingRuleListElement> pricingRules) {
        this.setPricingRules(pricingRules);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPricingRulesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBillingPeriod() != null) {
            sb.append("BillingPeriod: ").append(this.getBillingPeriod()).append(",");
        }
        if (this.getPricingRules() != null) {
            sb.append("PricingRules: ").append(this.getPricingRules()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricingRulesResult)) {
            return false;
        }
        ListPricingRulesResult other = (ListPricingRulesResult)obj;
        if (other.getBillingPeriod() == null ^ this.getBillingPeriod() == null) {
            return false;
        }
        if (other.getBillingPeriod() != null && !other.getBillingPeriod().equals(this.getBillingPeriod())) {
            return false;
        }
        if (other.getPricingRules() == null ^ this.getPricingRules() == null) {
            return false;
        }
        if (other.getPricingRules() != null && !other.getPricingRules().equals(this.getPricingRules())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBillingPeriod() == null ? 0 : this.getBillingPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getPricingRules() == null ? 0 : this.getPricingRules().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListPricingRulesResult clone() {
        try {
            return (ListPricingRulesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

