/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bcmdataexports.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bcmdataexports.model.TablePropertyDescription;
import com.amazonaws.services.bcmdataexports.model.transform.TableMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Table
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private String tableName;
    private List<TablePropertyDescription> tableProperties;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Table withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Table withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public List<TablePropertyDescription> getTableProperties() {
        return this.tableProperties;
    }

    public void setTableProperties(Collection<TablePropertyDescription> tableProperties) {
        if (tableProperties == null) {
            this.tableProperties = null;
            return;
        }
        this.tableProperties = new ArrayList<TablePropertyDescription>(tableProperties);
    }

    public Table withTableProperties(TablePropertyDescription ... tableProperties) {
        if (this.tableProperties == null) {
            this.setTableProperties(new ArrayList<TablePropertyDescription>(tableProperties.length));
        }
        for (TablePropertyDescription ele : tableProperties) {
            this.tableProperties.add(ele);
        }
        return this;
    }

    public Table withTableProperties(Collection<TablePropertyDescription> tableProperties) {
        this.setTableProperties(tableProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getTableProperties() != null) {
            sb.append("TableProperties: ").append(this.getTableProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getTableProperties() == null ^ this.getTableProperties() == null) {
            return false;
        }
        return other.getTableProperties() == null || other.getTableProperties().equals(this.getTableProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getTableProperties() == null ? 0 : this.getTableProperties().hashCode());
        return hashCode;
    }

    public Table clone() {
        try {
            return (Table)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

