/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.applicationautoscaling.model.Alarm;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutScalingPolicyResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String policyARN;
    private List<Alarm> alarms;

    public void setPolicyARN(String policyARN) {
        this.policyARN = policyARN;
    }

    public String getPolicyARN() {
        return this.policyARN;
    }

    public PutScalingPolicyResult withPolicyARN(String policyARN) {
        this.setPolicyARN(policyARN);
        return this;
    }

    public List<Alarm> getAlarms() {
        return this.alarms;
    }

    public void setAlarms(Collection<Alarm> alarms) {
        if (alarms == null) {
            this.alarms = null;
            return;
        }
        this.alarms = new ArrayList<Alarm>(alarms);
    }

    public PutScalingPolicyResult withAlarms(Alarm ... alarms) {
        if (this.alarms == null) {
            this.setAlarms(new ArrayList<Alarm>(alarms.length));
        }
        for (Alarm ele : alarms) {
            this.alarms.add(ele);
        }
        return this;
    }

    public PutScalingPolicyResult withAlarms(Collection<Alarm> alarms) {
        this.setAlarms(alarms);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyARN() != null) {
            sb.append("PolicyARN: ").append(this.getPolicyARN()).append(",");
        }
        if (this.getAlarms() != null) {
            sb.append("Alarms: ").append(this.getAlarms());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyResult)) {
            return false;
        }
        PutScalingPolicyResult other = (PutScalingPolicyResult)obj;
        if (other.getPolicyARN() == null ^ this.getPolicyARN() == null) {
            return false;
        }
        if (other.getPolicyARN() != null && !other.getPolicyARN().equals(this.getPolicyARN())) {
            return false;
        }
        if (other.getAlarms() == null ^ this.getAlarms() == null) {
            return false;
        }
        return other.getAlarms() == null || other.getAlarms().equals(this.getAlarms());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyARN() == null ? 0 : this.getPolicyARN().hashCode());
        hashCode = 31 * hashCode + (this.getAlarms() == null ? 0 : this.getAlarms().hashCode());
        return hashCode;
    }

    public PutScalingPolicyResult clone() {
        try {
            return (PutScalingPolicyResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

