/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j.generators;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class Launch4jFileVersionGenerator {
    private static final int REQUIRED_NESTED_VERSION_LEVELS = 4;
    private static final String SIMPLE_PROJECT_VERSION_REGEX = "^((\\d(\\.)?)*\\d+)(-\\w+)?$";
    private static final Pattern simpleProjectVersionPattern = Pattern.compile("^((\\d(\\.)?)*\\d+)(-\\w+)?$", 66);

    private Launch4jFileVersionGenerator() {
    }

    public static String generate(String projectVersion) {
        if (projectVersion == null) {
            return null;
        }
        if (!simpleProjectVersionPattern.matcher(projectVersion).matches()) {
            throw new IllegalArgumentException("'project.version' is in invalid format. Regex pattern: ^((\\d(\\.)?)*\\d+)(-\\w+)?$");
        }
        String versionLevels = Launch4jFileVersionGenerator.removeTextFlags(projectVersion);
        String limitedVersionLevels = Launch4jFileVersionGenerator.cutOffTooManyNestedLevels(versionLevels);
        return Launch4jFileVersionGenerator.appendMissingNestedLevelsByZeros(limitedVersionLevels);
    }

    private static String removeTextFlags(String version) {
        if (version.contains("-")) {
            String[] parts = version.split("-");
            return parts[0];
        }
        return version;
    }

    private static String cutOffTooManyNestedLevels(String versionLevels) {
        String[] levels = versionLevels.split("\\.");
        if (levels.length > 4) {
            List<String> limitedLevels = Arrays.asList(levels).subList(0, 4);
            return String.join((CharSequence)".", limitedLevels);
        }
        return versionLevels;
    }

    private static String appendMissingNestedLevelsByZeros(String versionLevels) {
        String[] levels = versionLevels.split("\\.");
        StringBuilder filledLevels = new StringBuilder(versionLevels);
        for (int i = levels.length; i < 4; ++i) {
            filledLevels.append(".0");
        }
        return filledLevels.toString();
    }
}

