/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Parameter;

public class ClassPath {
    @Parameter
    String mainClass;
    @Parameter(defaultValue="true")
    boolean addDependencies = true;
    @Parameter
    String jarLocation;
    @Parameter
    String preCp;
    @Parameter
    String postCp;

    private void addToCp(List<String> cp, String cpStr) {
        cp.addAll(Arrays.asList(cpStr.split("\\s*;\\s*")));
    }

    net.sf.launch4j.config.ClassPath toL4j(Set<Artifact> dependencies) {
        net.sf.launch4j.config.ClassPath ret = new net.sf.launch4j.config.ClassPath();
        ret.setMainClass(this.mainClass);
        ArrayList<String> cp = new ArrayList<String>();
        if (this.preCp != null) {
            this.addToCp(cp, this.preCp);
        }
        if (this.addDependencies) {
            if (this.jarLocation == null) {
                this.jarLocation = "";
            } else if (!this.jarLocation.endsWith("/")) {
                this.jarLocation = this.jarLocation + "/";
            }
            for (Artifact dependency : dependencies) {
                String depFilename = dependency.getFile().getName();
                cp.add(this.jarLocation + depFilename);
            }
        }
        if (this.postCp != null) {
            this.addToCp(cp, this.postCp);
        }
        ret.setPaths(cp);
        return ret;
    }

    public String toString() {
        return "ClassPath{mainClass='" + this.mainClass + '\'' + ", addDependencies=" + this.addDependencies + ", jarLocation='" + this.jarLocation + '\'' + ", preCp='" + this.preCp + '\'' + ", postCp='" + this.postCp + '\'' + '}';
    }
}

