/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.HaltonSequence;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.rng.RandomStream;

public class RandomStart
implements PointSetRandomization {
    protected RandomStream stream;

    public RandomStart() {
    }

    public RandomStart(RandomStream stream) {
        this.stream = stream;
    }

    @Override
    public void randomize(PointSet p) {
        if (!(p instanceof HaltonSequence)) {
            throw new IllegalArgumentException("RandomStart can only randomize a HaltonSequence");
        }
        double[] x0 = new double[p.getDimension()];
        this.stream.nextArrayOfDouble(x0, 0, x0.length);
        ((HaltonSequence)p).setStart(x0);
    }

    @Override
    public void setStream(RandomStream stream) {
        this.stream = stream;
    }

    @Override
    public RandomStream getStream() {
        return this.stream;
    }
}

