/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.MultivariateBrownianMotion;

public class MultivariateBrownianMotionPCABigSigma
extends MultivariateBrownianMotion {
    protected DoubleMatrix2D BigSigma;
    protected DoubleMatrix2D decompPCABigSigma;
    protected DoubleMatrix2D C;
    protected DoubleMatrix2D A;
    protected double[] z;
    protected double[] zz;
    protected boolean decompPCA;

    public MultivariateBrownianMotionPCABigSigma(int c, double[] x0, double[] mu, double[] sigma, double[][] corrZ, RandomStream stream) {
        this.gen = new NormalGen(stream, new NormalDist());
        this.setParams(c, x0, mu, sigma, corrZ);
    }

    public MultivariateBrownianMotionPCABigSigma(int c, double[] x0, double[] mu, double[] sigma, double[][] corrZ, NormalGen gen) {
        this.gen = gen;
        this.setParams(c, x0, mu, sigma, corrZ);
    }

    @Override
    public void setParams(int c, double[] x0, double[] mu, double[] sigma, double[][] corrZ) {
        this.decompPCA = false;
        super.setParams(c, x0, mu, sigma, corrZ);
    }

    protected DoubleMatrix2D decompPCA(DoubleMatrix2D BigSigma) {
        SingularValueDecomposition sv = new SingularValueDecomposition(BigSigma);
        DoubleMatrix2D D = sv.getS();
        for (int i = 0; i < D.rows(); ++i) {
            D.setQuick(i, i, Math.sqrt(D.getQuick(i, i)));
        }
        DoubleMatrix2D P = sv.getV();
        return P.zMult(D, null);
    }

    @Override
    protected void init() {
        super.init();
        this.BigSigma = new DenseDoubleMatrix2D(this.c * this.d, this.c * this.d);
        for (int i = 0; i < this.d; ++i) {
            for (int j = 0; j < this.d; ++j) {
                for (int k = 0; k < this.c; ++k) {
                    for (int l = 0; l < this.c; ++l) {
                        int g;
                        int n = g = i <= j ? i + 1 : j + 1;
                        if (k == l) {
                            this.BigSigma.setQuick(i * this.c + k, j * this.c + l, (double)g * this.sigma[k] * this.sigma[l] * (this.t[i + 1] - this.t[i]));
                            continue;
                        }
                        this.BigSigma.setQuick(i * this.c + k, j * this.c + l, (double)g * this.covZ.getQuick(k, l) * (this.t[i + 1] - this.t[i]));
                    }
                }
            }
        }
        this.decompPCABigSigma = this.decompPCA(this.BigSigma);
        this.decompPCA = true;
    }

    @Override
    public double[] generatePath() {
        int i;
        double sum = 0.0;
        double[] z = new double[this.c * this.d];
        if (!this.decompPCA) {
            this.init();
        }
        for (i = 0; i < this.c * this.d; ++i) {
            z[i] = this.gen.nextDouble();
        }
        for (int j = 0; j < this.d; ++j) {
            for (i = 0; i < this.c; ++i) {
                sum = 0.0;
                for (int k = 0; k < this.c * this.d; ++k) {
                    sum += this.decompPCABigSigma.getQuick(this.c * j + i, k) * z[k];
                }
                this.path[this.c * (j + 1) + i] = sum + this.mu[i] * (this.t[j + 1] - this.t[0]) + this.x0[i];
            }
        }
        this.observationIndex = this.d;
        return this.path;
    }

    @Override
    public double[] generatePath(double[] uniform01) {
        double sum = 0.0;
        if (!this.decompPCA) {
            this.init();
        }
        for (int j = 0; j < this.d; ++j) {
            for (int i = 0; i < this.c; ++i) {
                sum = 0.0;
                for (int k = 0; k < this.c * this.d; ++k) {
                    sum += this.decompPCABigSigma.getQuick(this.c * j + i, k) * uniform01[k];
                }
                this.path[this.c * (j + 1) + i] = sum + this.mu[i] * (this.t[j + 1] - this.t[0]) + this.x0[i];
            }
        }
        this.observationIndex = this.d;
        return this.path;
    }
}

