/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import java.util.Formatter;
import java.util.Locale;
import umontreal.ssj.functions.MathFunction;
import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.util.DMatrix;
import umontreal.ssj.util.PrintfFormat;
import umontreal.ssj.util.RootFinder;

public class HypoExponentialDist
extends ContinuousDistribution {
    protected double[] m_lambda;

    protected static void testLambda(double[] lambda) {
        int m = lambda.length;
        for (int j = 0; j < m; ++j) {
            if (!(lambda[j] <= 0.0)) continue;
            throw new IllegalArgumentException("lambda_j <= 0");
        }
    }

    private static DoubleMatrix2D buildMatrix(double[] lambda, double x) {
        int m = lambda.length;
        HypoExponentialDist.testLambda(lambda);
        DoubleFactory2D F2 = DoubleFactory2D.dense;
        DoubleMatrix2D A = F2.make(m, m);
        for (int j = 0; j < m - 1; ++j) {
            A.setQuick(j, j, -lambda[j] * x);
            A.setQuick(j, j + 1, lambda[j] * x);
        }
        A.setQuick(m - 1, m - 1, -lambda[m - 1] * x);
        return A;
    }

    public HypoExponentialDist(double[] lambda) {
        this.supportA = 0.0;
        this.setLambda(lambda);
    }

    @Override
    public double density(double x) {
        return HypoExponentialDist.density(this.m_lambda, x);
    }

    @Override
    public double cdf(double x) {
        return HypoExponentialDist.cdf(this.m_lambda, x);
    }

    @Override
    public double barF(double x) {
        return HypoExponentialDist.barF(this.m_lambda, x);
    }

    @Override
    public double inverseF(double u) {
        return HypoExponentialDist.inverseF(this.m_lambda, u);
    }

    @Override
    public double getMean() {
        return HypoExponentialDist.getMean(this.m_lambda);
    }

    @Override
    public double getVariance() {
        return HypoExponentialDist.getVariance(this.m_lambda);
    }

    @Override
    public double getStandardDeviation() {
        return HypoExponentialDist.getStandardDeviation(this.m_lambda);
    }

    public static double density(double[] lambda, double x) {
        if (x < 0.0) {
            return 0.0;
        }
        DoubleMatrix2D Ax = HypoExponentialDist.buildMatrix(lambda, x);
        DoubleMatrix2D T = DMatrix.expBidiagonal(Ax);
        int m = lambda.length;
        return lambda[m - 1] * T.getQuick(0, m - 1);
    }

    public static double cdf(double[] lambda, double x) {
        double LIMIT;
        double p;
        double std;
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= Double.MAX_VALUE) {
            return 1.0;
        }
        double mean = HypoExponentialDist.getMean(lambda);
        double LOW = mean - 1.5 * (std = HypoExponentialDist.getStandardDeviation(lambda));
        if (x > LOW && (p = 1.0 - HypoExponentialDist.barF(lambda, x)) > (LIMIT = 0.001)) {
            return p;
        }
        DoubleMatrix2D T = HypoExponentialDist.buildMatrix(lambda, x);
        DoubleFactory1D fac1 = DoubleFactory1D.dense;
        int m = lambda.length;
        DoubleMatrix1D C = fac1.make(m, 1.0);
        DoubleMatrix1D B = DMatrix.expmiBidiagonal(T, C);
        return Math.abs(B.getQuick(0));
    }

    public static double cdf2(double[] lambda, double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= Double.MAX_VALUE) {
            return 1.0;
        }
        return 1.0 - HypoExponentialDist.barF(lambda, x);
    }

    public static double barF(double[] lambda, double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        if (x >= Double.MAX_VALUE) {
            return 0.0;
        }
        DoubleMatrix2D T = HypoExponentialDist.buildMatrix(lambda, x);
        DoubleFactory1D fac1 = DoubleFactory1D.dense;
        int m = lambda.length;
        DoubleMatrix1D C = fac1.make(m, 1.0);
        DoubleMatrix1D B = DMatrix.expBidiagonal(T, C);
        return B.getQuick(0);
    }

    public static double inverseF(double[] lambda, double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return 0.0;
        }
        double EPS = 1.0E-12;
        myFunc fonc = new myFunc(lambda, u);
        double x1 = HypoExponentialDist.getMean(lambda);
        double v = HypoExponentialDist.cdf(lambda, x1);
        if (u <= v) {
            return RootFinder.brentDekker(0.0, x1, fonc, 1.0E-12);
        }
        double x2 = 4.0 * x1 + 1.0;
        v = HypoExponentialDist.cdf(lambda, x2);
        while (v < u) {
            x1 = x2;
            x2 = 4.0 * x2;
            v = HypoExponentialDist.cdf(lambda, x2);
        }
        return RootFinder.brentDekker(x1, x2, fonc, 1.0E-12);
    }

    public static double getMean(double[] lambda) {
        HypoExponentialDist.testLambda(lambda);
        int k = lambda.length;
        double sum = 0.0;
        for (int j = 0; j < k; ++j) {
            sum += 1.0 / lambda[j];
        }
        return sum;
    }

    public static double getVariance(double[] lambda) {
        HypoExponentialDist.testLambda(lambda);
        int k = lambda.length;
        double sum = 0.0;
        for (int j = 0; j < k; ++j) {
            sum += 1.0 / (lambda[j] * lambda[j]);
        }
        return sum;
    }

    public static double getStandardDeviation(double[] lambda) {
        double s = HypoExponentialDist.getVariance(lambda);
        return Math.sqrt(s);
    }

    public double[] getLambda() {
        return this.m_lambda;
    }

    public void setLambda(double[] lambda) {
        if (lambda == null) {
            return;
        }
        int k = lambda.length;
        this.m_lambda = new double[k];
        HypoExponentialDist.testLambda(lambda);
        System.arraycopy(lambda, 0, this.m_lambda, 0, k);
    }

    @Override
    public double[] getParams() {
        return this.m_lambda;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format(this.getClass().getSimpleName() + " : lambda = {" + PrintfFormat.NEWLINE, new Object[0]);
        int k = this.m_lambda.length;
        for (int i = 0; i < k; ++i) {
            formatter.format("   %g%n", this.m_lambda[i]);
        }
        formatter.format("}%n", new Object[0]);
        return sb.toString();
    }

    private static class myFunc
    implements MathFunction {
        private double[] m_lam;
        private double m_u;

        public myFunc(double[] lam, double u) {
            this.m_lam = lam;
            this.m_u = u;
        }

        @Override
        public double evaluate(double x) {
            return this.m_u - HypoExponentialDist.cdf(this.m_lam, x);
        }
    }
}

