/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.BrownianMotion;
import umontreal.ssj.stochprocess.GammaProcess;
import umontreal.ssj.stochprocess.StochasticProcess;

public class VarianceGammaProcess
extends StochasticProcess {
    protected GammaProcess randomTime;
    protected BrownianMotion BM;
    protected double theta;
    protected double sigma;
    protected double nu;

    public VarianceGammaProcess() {
    }

    public VarianceGammaProcess(double s0, double theta, double sigma, double nu, RandomStream stream) {
        this(s0, new BrownianMotion(s0, theta, sigma, stream), new GammaProcess(0.0, 1.0, nu, stream));
    }

    public VarianceGammaProcess(double s0, BrownianMotion BM, GammaProcess Gamma2) {
        this.BM = BM;
        Gamma2.setParams(0.0, 1.0, Gamma2.getNu());
        this.randomTime = Gamma2;
        this.setParams(s0, BM.getMu(), BM.getSigma(), Gamma2.getNu());
    }

    @Override
    public double nextObservation() {
        double nextBM = this.BM.nextObservation(this.randomTime.nextObservation());
        this.observationIndex = this.BM.getCurrentObservationIndex();
        this.path[this.observationIndex] = nextBM;
        ++this.observationCounter;
        return nextBM;
    }

    @Override
    public double[] generatePath() {
        this.BM.setObservationTimes(this.randomTime.generatePath(), this.d);
        this.path = this.BM.generatePath();
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] uniform01) {
        int dd = uniform01.length;
        int d = dd / 2;
        if (dd % 2 != 0) {
            throw new IllegalArgumentException("The Array uniform01 must have a even length");
        }
        double[] QMCpointsGP = new double[d];
        double[] QMCpointsBM = new double[d];
        for (int i = 0; i < d; ++i) {
            QMCpointsGP[i] = uniform01[2 * i];
            QMCpointsBM[i] = uniform01[2 * i + 1];
        }
        this.BM.setObservationTimes(this.randomTime.generatePath(QMCpointsGP), d);
        this.path = this.BM.generatePath(QMCpointsBM);
        this.observationIndex = d;
        this.observationCounter = d;
        return this.path;
    }

    @Override
    public void resetStartProcess() {
        this.observationIndex = 0;
        this.observationCounter = 0;
        this.BM.resetStartProcess();
        this.randomTime.resetStartProcess();
    }

    public void setParams(double s0, double theta, double sigma, double nu) {
        this.x0 = s0;
        this.theta = theta;
        this.sigma = sigma;
        this.nu = nu;
        if (this.observationTimesSet) {
            this.init();
        }
    }

    public double getTheta() {
        return this.theta;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getNu() {
        return this.nu;
    }

    @Override
    protected void init() {
        super.init();
        if (this.observationTimesSet) {
            this.randomTime.setObservationTimes(this.t, this.d);
            this.randomTime.x0 = this.t[0];
        }
    }

    @Override
    public void setObservationTimes(double[] t, int d) {
        super.setObservationTimes(t, d);
    }

    @Override
    public void setStream(RandomStream stream) {
        this.BM.setStream(stream);
    }

    @Override
    public RandomStream getStream() {
        return this.BM.getStream();
    }

    public BrownianMotion getBrownianMotion() {
        return this.BM;
    }

    public GammaProcess getGammaProcess() {
        return this.randomTime;
    }
}

