/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.list.lincv;

import cern.colt.matrix.DoubleMatrix2D;
import umontreal.ssj.stat.FunctionOfMultipleMeansTally;
import umontreal.ssj.stat.StatProbe;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.list.lincv.ListOfTalliesWithCV;
import umontreal.ssj.util.MultivariateFunction;

public class FunctionOfMultipleMeansTallyWithCV
extends FunctionOfMultipleMeansTally {
    private MultivariateFunction funcNoCV;
    private double[] beta;

    public FunctionOfMultipleMeansTallyWithCV(MultivariateFunction funcNoCV, int p, int q) {
        super((MultivariateFunction)new LinCVFunction(p + q), ListOfTalliesWithCV.createWithTally(p, q));
        this.funcNoCV = funcNoCV;
        this.beta = new double[q];
        ((LinCVFunction)this.getFunction()).initFunctionOfMultipleMeansTallyWithCV(this);
    }

    public FunctionOfMultipleMeansTallyWithCV(MultivariateFunction funcNoCV, ListOfTalliesWithCV<Tally> l) {
        super((MultivariateFunction)new LinCVFunction(l.size()), l);
        this.funcNoCV = funcNoCV;
        this.beta = new double[l.getNumControlVariables()];
        ((LinCVFunction)this.getFunction()).initFunctionOfMultipleMeansTallyWithCV(this);
    }

    public MultivariateFunction getFunctionWithoutCV() {
        return this.funcNoCV;
    }

    public int getNumControlVariables() {
        return this.beta.length;
    }

    public int getDimensionWithoutCV() {
        return this.getDimension() - this.beta.length;
    }

    public double getBeta(int i) {
        return this.beta[i];
    }

    public void setBeta(int i, double b) {
        this.beta[i] = b;
    }

    public double[] getBeta() {
        return this.beta;
    }

    public void setBeta(double[] beta) {
        if (beta.length != this.beta.length) {
            throw new IllegalArgumentException("Invalid length of beta");
        }
        this.beta = beta;
    }

    public ListOfTalliesWithCV<Tally> getListOfTalliesWithCV() {
        return (ListOfTalliesWithCV)super.getListOfTallies();
    }

    public double getExpectedValue(int i) {
        return this.getListOfTalliesWithCV().getExpectedValue(i);
    }

    public void setExpectedValue(int i, double e) {
        this.getListOfTalliesWithCV().setExpectedValue(i, e);
    }

    public double[] getExpectedValues() {
        return this.getListOfTalliesWithCV().getExpectedValues();
    }

    public void setExpectedValues(double[] exp) {
        this.getListOfTalliesWithCV().setExpectedValues(exp);
    }

    public void estimateBeta() {
        ListOfTalliesWithCV<Tally> a = this.getListOfTalliesWithCV();
        a.estimateBeta();
        this.estimateBetaFromMatrix(a.getBeta());
    }

    public void estimateBetaFromMatrix(DoubleMatrix2D mbeta) {
        int i;
        ListOfTalliesWithCV<Tally> a = this.getListOfTalliesWithCV();
        int p = this.getDimension() - this.beta.length;
        int q = this.beta.length;
        double[] avg = new double[p];
        double[] gradient = new double[p];
        for (i = 0; i < p; ++i) {
            avg[i] = ((StatProbe)a.get(i)).average();
        }
        for (i = 0; i < p; ++i) {
            gradient[i] = this.funcNoCV.evaluateGradient(i, avg);
        }
        for (i = 0; i < q; ++i) {
            this.beta[i] = 0.0;
            for (int j = 0; j < p; ++j) {
                int n = i;
                this.beta[n] = this.beta[n] + mbeta.getQuick(i, j) * gradient[j];
            }
        }
    }

    @Override
    public FunctionOfMultipleMeansTallyWithCV clone() {
        FunctionOfMultipleMeansTallyWithCV mta = (FunctionOfMultipleMeansTallyWithCV)super.clone();
        mta.beta = (double[])this.beta.clone();
        LinCVFunction fct = new LinCVFunction(this.getDimension());
        mta.func = fct;
        fct.initFunctionOfMultipleMeansTallyWithCV(mta);
        return mta;
    }

    private static class LinCVFunction
    implements MultivariateFunction {
        private FunctionOfMultipleMeansTallyWithCV fcv;
        private int pplusq;
        private double[] tmp;

        public LinCVFunction(int pplusq) {
            this.pplusq = pplusq;
        }

        public void initFunctionOfMultipleMeansTallyWithCV(FunctionOfMultipleMeansTallyWithCV fcv) {
            this.fcv = fcv;
            this.tmp = new double[fcv.getListOfTalliesWithCV().sizeWithoutCV()];
        }

        @Override
        public int getDimension() {
            return this.pplusq;
        }

        @Override
        public double evaluate(double ... x) {
            MultivariateFunction funcNoCV = this.fcv.getFunctionWithoutCV();
            if (x.length != this.getDimension()) {
                throw new IllegalArgumentException("x has length " + x.length + ", which differs from the dimension " + this.getDimension());
            }
            int d = this.getDimension() - this.fcv.beta.length;
            System.arraycopy(x, 0, this.tmp, 0, d);
            double gValue = funcNoCV.evaluate(this.tmp);
            ListOfTalliesWithCV<Tally> a = this.fcv.getListOfTalliesWithCV();
            for (int i = 0; i < this.fcv.beta.length; ++i) {
                gValue -= this.fcv.beta[i] * (x[d + i] - a.getExpectedValue(i));
            }
            return gValue;
        }

        @Override
        public double evaluateGradient(int i, double ... x) {
            MultivariateFunction funcNoCV = this.fcv.getFunctionWithoutCV();
            if (x.length != this.getDimension()) {
                throw new IllegalArgumentException("x has length " + x.length + ", which differs from the dimension " + this.getDimension());
            }
            int d = this.getDimension() - this.fcv.beta.length;
            if (i < d) {
                System.arraycopy(x, 0, this.tmp, 0, d);
                return funcNoCV.evaluateGradient(i, this.tmp);
            }
            return -this.fcv.beta[i - d];
        }
    }
}

