/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.simevents.eventlist;

import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import umontreal.ssj.simevents.Event;
import umontreal.ssj.simevents.eventlist.EventList;
import umontreal.ssj.util.PrintfFormat;

public class RedblackTree
implements EventList {
    private TreeMap<Event, Node> tree = new TreeMap(new EventComparator());
    private static Node free = null;
    private int modCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void clear() {
        Iterator<Node> itr = this.tree.values().iterator();
        while (true) {
            if (!itr.hasNext()) {
                ++this.modCount;
                return;
            }
            Node node = itr.next();
            node.events.clear();
            itr.remove();
            Class<RedblackTree> clazz = RedblackTree.class;
            // MONITORENTER : umontreal.ssj.simevents.eventlist.RedblackTree.class
            node.nextNode = free;
            free = node;
            // MONITOREXIT : clazz
        }
    }

    @Override
    public void add(Event ev) {
        Node node = this.tree.get(ev);
        if (node != null) {
            node.events.add(ev);
        } else {
            this.tree.put(new EventMapKey(ev), this.newNode(ev));
        }
        ++this.modCount;
    }

    @Override
    public void addFirst(Event ev) {
        Node node = this.tree.get(ev);
        if (node != null) {
            node.events.add(ev);
        } else {
            this.tree.put(new EventMapKey(ev), this.newNode(ev));
        }
        ++this.modCount;
    }

    @Override
    public void addBefore(Event ev, Event other) {
        Node node = this.tree.get(other);
        if (node == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        node.addBefore(ev, other);
        ++this.modCount;
    }

    @Override
    public void addAfter(Event ev, Event other) {
        Node node = this.tree.get(other);
        if (node == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        node.addAfter(ev, other);
        ++this.modCount;
    }

    @Override
    public Event getFirst() {
        return this.isEmpty() ? null : this.tree.get((Object)this.tree.firstKey()).events.get(0);
    }

    @Override
    public Event getFirstOfClass(String cl) {
        for (Node node : this.tree.values()) {
            Event ev = node.getFirstOfClass(cl);
            if (ev == null) continue;
            return ev;
        }
        return null;
    }

    @Override
    public <E extends Event> E getFirstOfClass(Class<E> cl) {
        for (Node node : this.tree.values()) {
            E ev = node.getFirstOfClass(cl);
            if (ev == null) continue;
            return ev;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean remove(Event ev) {
        Node node = this.tree.get(ev);
        if (node == null) {
            return false;
        }
        if (node.remove(ev)) {
            this.tree.remove(ev);
            Class<RedblackTree> clazz = RedblackTree.class;
            // MONITORENTER : umontreal.ssj.simevents.eventlist.RedblackTree.class
            node.nextNode = free;
            free = node;
            // MONITOREXIT : clazz
        }
        ++this.modCount;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Event removeFirst() {
        if (this.tree.isEmpty()) {
            return null;
        }
        Event evKey = this.tree.firstKey();
        Node node = this.tree.get(evKey);
        Event first = node.events.get(0);
        node.events.remove(0);
        if (node.events.isEmpty()) {
            this.tree.remove(evKey);
            Class<RedblackTree> clazz = RedblackTree.class;
            // MONITORENTER : umontreal.ssj.simevents.eventlist.RedblackTree.class
            node.nextNode = free;
            free = node;
            // MONITOREXIT : clazz
        }
        ++this.modCount;
        return first;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Contents of the event list RedblackTree:");
        for (Node node : this.tree.values()) {
            for (Event ev : node.events) {
                sb.append(PrintfFormat.NEWLINE + PrintfFormat.g(12, 7, ev.time()) + ", " + PrintfFormat.g(8, 4, ev.priority()) + " : " + ev.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public Iterator<Event> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Event> listIterator() {
        return new RBItr();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node newNode(Event ev) {
        Class<RedblackTree> clazz = RedblackTree.class;
        synchronized (RedblackTree.class) {
            if (free == null) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return new Node(ev);
            }
            Node temp = free;
            free = RedblackTree.free.nextNode;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            temp.events.add(ev);
            return temp;
        }
    }

    private class EventMapKey
    extends Event {
        public EventMapKey(Event ev) {
            this.eventTime = ev.time();
            this.priority = ev.priority();
        }

        @Override
        public void actions() {
        }
    }

    private class RBItr
    implements ListIterator<Event> {
        private int expectedModCount;
        private Node prevNode;
        private Node nextNode;
        private int prevNodeIndex;
        private int nextNodeIndex;
        private int nextIndex;

        RBItr() {
            this.expectedModCount = RedblackTree.this.modCount;
            this.prevNode = null;
            this.nextNode = RedblackTree.this.tree.isEmpty() ? null : (Node)RedblackTree.this.tree.get(RedblackTree.this.tree.firstKey());
            this.prevNodeIndex = 0;
            this.nextNodeIndex = 0;
            this.nextIndex = 0;
            Iterator itr = RedblackTree.this.tree.values().iterator();
            Node lastNode = null;
            while (itr.hasNext()) {
                Node node = (Node)itr.next();
                node.prevNode = lastNode;
                if (lastNode != null) {
                    lastNode.nextNode = node;
                }
                node.nextNode = null;
                lastNode = node;
            }
        }

        @Override
        public void add(Event ev) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (RedblackTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextNode != null && this.nextNodeIndex < this.nextNode.events.size();
        }

        @Override
        public boolean hasPrevious() {
            if (RedblackTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.prevNode != null && this.prevNodeIndex >= 0;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Event ev = this.nextNode.events.get(this.nextNodeIndex);
            this.prevNode = this.nextNode;
            this.prevNodeIndex = this.nextNodeIndex++;
            if (this.nextNodeIndex >= this.nextNode.events.size()) {
                this.nextNode = this.nextNode.nextNode;
                this.nextNodeIndex = 0;
            }
            return ev;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex;
        }

        @Override
        public Event previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            Event ev = this.prevNode.events.get(this.prevNodeIndex);
            this.nextNode = this.prevNode;
            this.nextNodeIndex = this.prevNodeIndex--;
            if (this.prevNodeIndex < 0) {
                this.prevNode = this.prevNode.prevNode;
                if (this.prevNode != null) {
                    this.prevNodeIndex = this.prevNode.events.size() - 1;
                }
            }
            return ev;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Event ev) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EventComparator
    implements Comparator<Event> {
        private EventComparator() {
        }

        @Override
        public int compare(Event ev1, Event ev2) {
            return ev1.compareTo(ev2);
        }

        @Override
        public boolean equals(Object obj) {
            return true;
        }
    }

    private static class Node {
        public Node prevNode = null;
        public Node nextNode = null;
        public List<Event> events = new LinkedList<Event>();

        public Node(Event ev) {
            this.events.add(ev);
        }

        public void addAfter(Event ev, Event other) {
            ListIterator<Event> itr = this.events.listIterator();
            while (itr.hasNext()) {
                Event listev = itr.next();
                if (listev != other) continue;
                itr.add(ev);
                return;
            }
            throw new IllegalArgumentException("Event not in node.");
        }

        public void addBefore(Event ev, Event other) {
            ListIterator<Event> itr = this.events.listIterator();
            while (itr.hasNext()) {
                Event listev = itr.next();
                if (listev != other) continue;
                itr.previous();
                itr.add(ev);
                return;
            }
            throw new IllegalArgumentException("Event not in node.");
        }

        public Event getFirstOfClass(String cl) {
            for (Event listev : this.events) {
                if (!listev.getClass().getName().equals(cl)) continue;
                return listev;
            }
            return null;
        }

        public <E extends Event> E getFirstOfClass(Class<E> cl) {
            for (Event listev : this.events) {
                if (listev.getClass() != cl) continue;
                return (E)listev;
            }
            return null;
        }

        public boolean remove(Event ev) {
            Iterator<Event> itr = this.events.iterator();
            while (itr.hasNext()) {
                Event listev = itr.next();
                if (listev != ev) continue;
                itr.remove();
                return this.events.isEmpty();
            }
            throw new IllegalArgumentException("Event not in node.");
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            Iterator<Event> itr = this.events.iterator();
            while (itr.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(itr.next());
            }
            return sb.toString();
        }
    }
}

