/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.CachedPointSet;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.rng.RandomStream;

public class IndependentPointsCached
extends CachedPointSet {
    public IndependentPointsCached(int n, int dim) {
        this.dim = dim;
        this.numPoints = n;
        this.x = new double[this.numPoints][dim];
    }

    @Override
    public void randomize(RandomStream stream) {
        for (int j = 0; j < this.dim; ++j) {
            for (int i = 0; i < this.numPoints; ++i) {
                this.x[i][j] = stream.nextDouble();
            }
        }
    }

    @Override
    public void addRandomShift(int fromDim, int toDim, RandomStream stream) {
        this.randomize(stream);
    }

    @Override
    public void randomize(PointSetRandomization rand) {
        this.randomize(rand.getStream());
    }

    @Override
    public String toString() {
        return "IndependentPointsCached: independent points in " + this.dim + "dimensions.";
    }
}

