/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.util.FileCodeMapper;

public abstract class CodeMapper {
    private static CodeMapper codeMapper = null;

    public static synchronized CodeMapper getInstance() throws HL7Exception {
        if (codeMapper == null) {
            codeMapper = new FileCodeMapper();
        }
        return codeMapper;
    }

    public static String getLocal(String interfaceName, int hl7Table, String interfaceCode) throws HL7Exception {
        return CodeMapper.getInstance().getLocalCode(interfaceName, hl7Table, interfaceCode);
    }

    public static String getInt(String interfaceName, int hl7Table, String localCode) throws HL7Exception {
        return CodeMapper.getInstance().getInterfaceCode(interfaceName, hl7Table, localCode);
    }

    public abstract String getInterfaceCode(String var1, int var2, String var3) throws HL7Exception;

    public abstract String getLocalCode(String var1, int var2, String var3) throws HL7Exception;

    public abstract void throwExceptionIfNoMatch(boolean var1);

    public abstract void refreshCache() throws HL7Exception;
}

