/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGlobalClusterResponse extends RdsResponse implements
        ToCopyableBuilder<CreateGlobalClusterResponse.Builder, CreateGlobalClusterResponse> {
    private static final SdkField<GlobalCluster> GLOBAL_CLUSTER_FIELD = SdkField
            .<GlobalCluster> builder(MarshallingType.SDK_POJO).memberName("GlobalCluster")
            .getter(getter(CreateGlobalClusterResponse::globalCluster)).setter(setter(Builder::globalCluster))
            .constructor(GlobalCluster::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalCluster").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_CLUSTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final GlobalCluster globalCluster;

    private CreateGlobalClusterResponse(BuilderImpl builder) {
        super(builder);
        this.globalCluster = builder.globalCluster;
    }

    /**
     * Returns the value of the GlobalCluster property for this object.
     * 
     * @return The value of the GlobalCluster property for this object.
     */
    public final GlobalCluster globalCluster() {
        return globalCluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalCluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlobalClusterResponse)) {
            return false;
        }
        CreateGlobalClusterResponse other = (CreateGlobalClusterResponse) obj;
        return Objects.equals(globalCluster(), other.globalCluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGlobalClusterResponse").add("GlobalCluster", globalCluster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalCluster":
            return Optional.ofNullable(clazz.cast(globalCluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GlobalCluster", GLOBAL_CLUSTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlobalClusterResponse, T> g) {
        return obj -> g.apply((CreateGlobalClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGlobalClusterResponse> {
        /**
         * Sets the value of the GlobalCluster property for this object.
         *
         * @param globalCluster
         *        The new value for the GlobalCluster property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalCluster(GlobalCluster globalCluster);

        /**
         * Sets the value of the GlobalCluster property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GlobalCluster.Builder} avoiding the need
         * to create one manually via {@link GlobalCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlobalCluster.Builder#build()} is called immediately and its
         * result is passed to {@link #globalCluster(GlobalCluster)}.
         * 
         * @param globalCluster
         *        a consumer that will call methods on {@link GlobalCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalCluster(GlobalCluster)
         */
        default Builder globalCluster(Consumer<GlobalCluster.Builder> globalCluster) {
            return globalCluster(GlobalCluster.builder().applyMutation(globalCluster).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private GlobalCluster globalCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlobalClusterResponse model) {
            super(model);
            globalCluster(model.globalCluster);
        }

        public final GlobalCluster.Builder getGlobalCluster() {
            return globalCluster != null ? globalCluster.toBuilder() : null;
        }

        public final void setGlobalCluster(GlobalCluster.BuilderImpl globalCluster) {
            this.globalCluster = globalCluster != null ? globalCluster.build() : null;
        }

        @Override
        public final Builder globalCluster(GlobalCluster globalCluster) {
            this.globalCluster = globalCluster;
            return this;
        }

        @Override
        public CreateGlobalClusterResponse build() {
            return new CreateGlobalClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
