/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyOptionGroupRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyOptionGroupRequest.Builder, ModifyOptionGroupRequest> {
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(ModifyOptionGroupRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<List<OptionConfiguration>> OPTIONS_TO_INCLUDE_FIELD = SdkField
            .<List<OptionConfiguration>> builder(MarshallingType.LIST)
            .memberName("OptionsToInclude")
            .getter(getter(ModifyOptionGroupRequest::optionsToInclude))
            .setter(setter(Builder::optionsToInclude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionsToInclude").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OptionConfiguration")
                            .memberFieldInfo(
                                    SdkField.<OptionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OptionConfiguration").build()).build()).build()).build();

    private static final SdkField<List<String>> OPTIONS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OptionsToRemove")
            .getter(getter(ModifyOptionGroupRequest::optionsToRemove))
            .setter(setter(Builder::optionsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(ModifyOptionGroupRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUP_NAME_FIELD,
            OPTIONS_TO_INCLUDE_FIELD, OPTIONS_TO_REMOVE_FIELD, APPLY_IMMEDIATELY_FIELD));

    private final String optionGroupName;

    private final List<OptionConfiguration> optionsToInclude;

    private final List<String> optionsToRemove;

    private final Boolean applyImmediately;

    private ModifyOptionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.optionGroupName = builder.optionGroupName;
        this.optionsToInclude = builder.optionsToInclude;
        this.optionsToRemove = builder.optionsToRemove;
        this.applyImmediately = builder.applyImmediately;
    }

    /**
     * <p>
     * The name of the option group to be modified.
     * </p>
     * <p>
     * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option
     * group, and that option group can't be removed from a DB instance once it is associated with a DB instance
     * </p>
     * 
     * @return The name of the option group to be modified.</p>
     *         <p>
     *         Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an
     *         option group, and that option group can't be removed from a DB instance once it is associated with a DB
     *         instance
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionsToInclude property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionsToInclude() {
        return optionsToInclude != null && !(optionsToInclude instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Options in this list are added to the option group or, if already present, the specified configuration is used to
     * update the existing configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionsToInclude} method.
     * </p>
     * 
     * @return Options in this list are added to the option group or, if already present, the specified configuration is
     *         used to update the existing configuration.
     */
    public final List<OptionConfiguration> optionsToInclude() {
        return optionsToInclude;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionsToRemove property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionsToRemove() {
        return optionsToRemove != null && !(optionsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Options in this list are removed from the option group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionsToRemove} method.
     * </p>
     * 
     * @return Options in this list are removed from the option group.
     */
    public final List<String> optionsToRemove() {
        return optionsToRemove;
    }

    /**
     * <p>
     * Specifies whether to apply the change immediately or during the next maintenance window for each instance
     * associated with the option group.
     * </p>
     * 
     * @return Specifies whether to apply the change immediately or during the next maintenance window for each instance
     *         associated with the option group.
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionsToInclude() ? optionsToInclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionsToRemove() ? optionsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyOptionGroupRequest)) {
            return false;
        }
        ModifyOptionGroupRequest other = (ModifyOptionGroupRequest) obj;
        return Objects.equals(optionGroupName(), other.optionGroupName()) && hasOptionsToInclude() == other.hasOptionsToInclude()
                && Objects.equals(optionsToInclude(), other.optionsToInclude())
                && hasOptionsToRemove() == other.hasOptionsToRemove()
                && Objects.equals(optionsToRemove(), other.optionsToRemove())
                && Objects.equals(applyImmediately(), other.applyImmediately());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyOptionGroupRequest").add("OptionGroupName", optionGroupName())
                .add("OptionsToInclude", hasOptionsToInclude() ? optionsToInclude() : null)
                .add("OptionsToRemove", hasOptionsToRemove() ? optionsToRemove() : null)
                .add("ApplyImmediately", applyImmediately()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "OptionsToInclude":
            return Optional.ofNullable(clazz.cast(optionsToInclude()));
        case "OptionsToRemove":
            return Optional.ofNullable(clazz.cast(optionsToRemove()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyOptionGroupRequest, T> g) {
        return obj -> g.apply((ModifyOptionGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyOptionGroupRequest> {
        /**
         * <p>
         * The name of the option group to be modified.
         * </p>
         * <p>
         * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option
         * group, and that option group can't be removed from a DB instance once it is associated with a DB instance
         * </p>
         * 
         * @param optionGroupName
         *        The name of the option group to be modified.</p>
         *        <p>
         *        Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an
         *        option group, and that option group can't be removed from a DB instance once it is associated with a
         *        DB instance
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * Options in this list are added to the option group or, if already present, the specified configuration is
         * used to update the existing configuration.
         * </p>
         * 
         * @param optionsToInclude
         *        Options in this list are added to the option group or, if already present, the specified configuration
         *        is used to update the existing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsToInclude(Collection<OptionConfiguration> optionsToInclude);

        /**
         * <p>
         * Options in this list are added to the option group or, if already present, the specified configuration is
         * used to update the existing configuration.
         * </p>
         * 
         * @param optionsToInclude
         *        Options in this list are added to the option group or, if already present, the specified configuration
         *        is used to update the existing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsToInclude(OptionConfiguration... optionsToInclude);

        /**
         * <p>
         * Options in this list are added to the option group or, if already present, the specified configuration is
         * used to update the existing configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.OptionConfiguration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.OptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.OptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #optionsToInclude(List<OptionConfiguration>)}.
         * 
         * @param optionsToInclude
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.OptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionsToInclude(java.util.Collection<OptionConfiguration>)
         */
        Builder optionsToInclude(Consumer<OptionConfiguration.Builder>... optionsToInclude);

        /**
         * <p>
         * Options in this list are removed from the option group.
         * </p>
         * 
         * @param optionsToRemove
         *        Options in this list are removed from the option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsToRemove(Collection<String> optionsToRemove);

        /**
         * <p>
         * Options in this list are removed from the option group.
         * </p>
         * 
         * @param optionsToRemove
         *        Options in this list are removed from the option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsToRemove(String... optionsToRemove);

        /**
         * <p>
         * Specifies whether to apply the change immediately or during the next maintenance window for each instance
         * associated with the option group.
         * </p>
         * 
         * @param applyImmediately
         *        Specifies whether to apply the change immediately or during the next maintenance window for each
         *        instance associated with the option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String optionGroupName;

        private List<OptionConfiguration> optionsToInclude = DefaultSdkAutoConstructList.getInstance();

        private List<String> optionsToRemove = DefaultSdkAutoConstructList.getInstance();

        private Boolean applyImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyOptionGroupRequest model) {
            super(model);
            optionGroupName(model.optionGroupName);
            optionsToInclude(model.optionsToInclude);
            optionsToRemove(model.optionsToRemove);
            applyImmediately(model.applyImmediately);
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final List<OptionConfiguration.Builder> getOptionsToInclude() {
            List<OptionConfiguration.Builder> result = OptionConfigurationListCopier.copyToBuilder(this.optionsToInclude);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionsToInclude(Collection<OptionConfiguration.BuilderImpl> optionsToInclude) {
            this.optionsToInclude = OptionConfigurationListCopier.copyFromBuilder(optionsToInclude);
        }

        @Override
        public final Builder optionsToInclude(Collection<OptionConfiguration> optionsToInclude) {
            this.optionsToInclude = OptionConfigurationListCopier.copy(optionsToInclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToInclude(OptionConfiguration... optionsToInclude) {
            optionsToInclude(Arrays.asList(optionsToInclude));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToInclude(Consumer<OptionConfiguration.Builder>... optionsToInclude) {
            optionsToInclude(Stream.of(optionsToInclude).map(c -> OptionConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getOptionsToRemove() {
            if (optionsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return optionsToRemove;
        }

        public final void setOptionsToRemove(Collection<String> optionsToRemove) {
            this.optionsToRemove = OptionNamesListCopier.copy(optionsToRemove);
        }

        @Override
        public final Builder optionsToRemove(Collection<String> optionsToRemove) {
            this.optionsToRemove = OptionNamesListCopier.copy(optionsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsToRemove(String... optionsToRemove) {
            optionsToRemove(Arrays.asList(optionsToRemove));
            return this;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyOptionGroupRequest build() {
            return new ModifyOptionGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
