/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BacktrackDbClusterRequest extends RdsRequest implements
        ToCopyableBuilder<BacktrackDbClusterRequest.Builder, BacktrackDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(BacktrackDbClusterRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<Instant> BACKTRACK_TO_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BacktrackTo").getter(getter(BacktrackDbClusterRequest::backtrackTo))
            .setter(setter(Builder::backtrackTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackTo").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Force")
            .getter(getter(BacktrackDbClusterRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force").build()).build();

    private static final SdkField<Boolean> USE_EARLIEST_TIME_ON_POINT_IN_TIME_UNAVAILABLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseEarliestTimeOnPointInTimeUnavailable")
            .getter(getter(BacktrackDbClusterRequest::useEarliestTimeOnPointInTimeUnavailable))
            .setter(setter(Builder::useEarliestTimeOnPointInTimeUnavailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UseEarliestTimeOnPointInTimeUnavailable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD,
            BACKTRACK_TO_FIELD, FORCE_FIELD, USE_EARLIEST_TIME_ON_POINT_IN_TIME_UNAVAILABLE_FIELD));

    private final String dbClusterIdentifier;

    private final Instant backtrackTo;

    private final Boolean force;

    private final Boolean useEarliestTimeOnPointInTimeUnavailable;

    private BacktrackDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.backtrackTo = builder.backtrackTo;
        this.force = builder.force;
        this.useEarliestTimeOnPointInTimeUnavailable = builder.useEarliestTimeOnPointInTimeUnavailable;
    }

    /**
     * <p>
     * The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-cluster1</code>
     * </p>
     * 
     * @return The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase
     *         string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-cluster1</code>
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information
     * about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
     * </p>
     * <note>
     * <p>
     * If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest
     * possible consistent time for the DB cluster.
     * </p>
     * </note>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain a valid ISO 8601 timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't contain a timestamp set in the future.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>2017-07-08T18:00Z</code>
     * </p>
     * 
     * @return The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more
     *         information about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia
     *         page.</a> </p> <note>
     *         <p>
     *         If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the
     *         nearest possible consistent time for the DB cluster.
     *         </p>
     *         </note>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain a valid ISO 8601 timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't contain a timestamp set in the future.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>2017-07-08T18:00Z</code>
     */
    public final Instant backtrackTo() {
        return backtrackTo;
    }

    /**
     * <p>
     * Specifies whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs
     * when binary logging is enabled.
     * </p>
     * 
     * @return Specifies whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an
     *         error occurs when binary logging is enabled.
     */
    public final Boolean force() {
        return force;
    }

    /**
     * <p>
     * Specifies whether to backtrack the DB cluster to the earliest possible backtrack time when <i>BacktrackTo</i> is
     * set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and
     * <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time, an error occurs.
     * </p>
     * 
     * @return Specifies whether to backtrack the DB cluster to the earliest possible backtrack time when
     *         <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time. When this parameter is
     *         disabled and <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time, an error
     *         occurs.
     */
    public final Boolean useEarliestTimeOnPointInTimeUnavailable() {
        return useEarliestTimeOnPointInTimeUnavailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(backtrackTo());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        hashCode = 31 * hashCode + Objects.hashCode(useEarliestTimeOnPointInTimeUnavailable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BacktrackDbClusterRequest)) {
            return false;
        }
        BacktrackDbClusterRequest other = (BacktrackDbClusterRequest) obj;
        return Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(backtrackTo(), other.backtrackTo()) && Objects.equals(force(), other.force())
                && Objects.equals(useEarliestTimeOnPointInTimeUnavailable(), other.useEarliestTimeOnPointInTimeUnavailable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BacktrackDbClusterRequest").add("DBClusterIdentifier", dbClusterIdentifier())
                .add("BacktrackTo", backtrackTo()).add("Force", force())
                .add("UseEarliestTimeOnPointInTimeUnavailable", useEarliestTimeOnPointInTimeUnavailable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "BacktrackTo":
            return Optional.ofNullable(clazz.cast(backtrackTo()));
        case "Force":
            return Optional.ofNullable(clazz.cast(force()));
        case "UseEarliestTimeOnPointInTimeUnavailable":
            return Optional.ofNullable(clazz.cast(useEarliestTimeOnPointInTimeUnavailable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BacktrackDbClusterRequest, T> g) {
        return obj -> g.apply((BacktrackDbClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, BacktrackDbClusterRequest> {
        /**
         * <p>
         * The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase
         * string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-cluster1</code>
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase
         *        string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-cluster1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information
         * about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
         * </p>
         * <note>
         * <p>
         * If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest
         * possible consistent time for the DB cluster.
         * </p>
         * </note>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain a valid ISO 8601 timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't contain a timestamp set in the future.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>2017-07-08T18:00Z</code>
         * </p>
         * 
         * @param backtrackTo
         *        The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more
         *        information about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia
         *        page.</a> </p> <note>
         *        <p>
         *        If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the
         *        nearest possible consistent time for the DB cluster.
         *        </p>
         *        </note>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain a valid ISO 8601 timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't contain a timestamp set in the future.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>2017-07-08T18:00Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backtrackTo(Instant backtrackTo);

        /**
         * <p>
         * Specifies whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error
         * occurs when binary logging is enabled.
         * </p>
         * 
         * @param force
         *        Specifies whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an
         *        error occurs when binary logging is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        /**
         * <p>
         * Specifies whether to backtrack the DB cluster to the earliest possible backtrack time when <i>BacktrackTo</i>
         * is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and
         * <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time, an error occurs.
         * </p>
         * 
         * @param useEarliestTimeOnPointInTimeUnavailable
         *        Specifies whether to backtrack the DB cluster to the earliest possible backtrack time when
         *        <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time. When this parameter
         *        is disabled and <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time, an
         *        error occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useEarliestTimeOnPointInTimeUnavailable(Boolean useEarliestTimeOnPointInTimeUnavailable);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbClusterIdentifier;

        private Instant backtrackTo;

        private Boolean force;

        private Boolean useEarliestTimeOnPointInTimeUnavailable;

        private BuilderImpl() {
        }

        private BuilderImpl(BacktrackDbClusterRequest model) {
            super(model);
            dbClusterIdentifier(model.dbClusterIdentifier);
            backtrackTo(model.backtrackTo);
            force(model.force);
            useEarliestTimeOnPointInTimeUnavailable(model.useEarliestTimeOnPointInTimeUnavailable);
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Instant getBacktrackTo() {
            return backtrackTo;
        }

        public final void setBacktrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
        }

        @Override
        public final Builder backtrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final Boolean getUseEarliestTimeOnPointInTimeUnavailable() {
            return useEarliestTimeOnPointInTimeUnavailable;
        }

        public final void setUseEarliestTimeOnPointInTimeUnavailable(Boolean useEarliestTimeOnPointInTimeUnavailable) {
            this.useEarliestTimeOnPointInTimeUnavailable = useEarliestTimeOnPointInTimeUnavailable;
        }

        @Override
        public final Builder useEarliestTimeOnPointInTimeUnavailable(Boolean useEarliestTimeOnPointInTimeUnavailable) {
            this.useEarliestTimeOnPointInTimeUnavailable = useEarliestTimeOnPointInTimeUnavailable;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BacktrackDbClusterRequest build() {
            return new BacktrackDbClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
