/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.support;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedProcessor
implements ResourcePreProcessor {
    private List<ResourcePreProcessor> processors = new ArrayList<ResourcePreProcessor>();

    private ChainedProcessor(List<ResourcePreProcessor> processors) {
        this.processors = processors;
    }

    public static ChainedProcessor create(ResourcePreProcessor ... processors) {
        ArrayList<ResourcePreProcessor> processorsAsList = new ArrayList<ResourcePreProcessor>();
        if (processors != null) {
            processorsAsList.addAll(Arrays.asList(processors));
        }
        return new ChainedProcessor(processorsAsList);
    }

    @Override
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        Reader tempReader = reader;
        StringWriter tempWriter = new StringWriter();
        for (ResourcePreProcessor processor : this.processors) {
            tempWriter = new StringWriter();
            processor.process(resource, tempReader, tempWriter);
            tempReader = new StringReader(((Object)tempWriter).toString());
        }
        writer.write(((Object)tempWriter).toString());
    }
}

