/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.support.AbstractConfigurableStrategySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurableSingleStrategy<S, P>
extends AbstractConfigurableStrategySupport<S, P> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigurableSingleStrategy.class);
    @Inject
    private Injector injector;
    private S configuredStrategy;

    public final S getConfiguredStrategy() {
        if (this.configuredStrategy == null) {
            String alias = this.getConfiguredValue();
            this.configuredStrategy = this.getDefaultStrategy();
            if (!StringUtils.isEmpty((CharSequence)alias)) {
                LOG.debug("configured alias: {}", (Object)alias);
                this.configuredStrategy = this.getStrategyForAlias(alias);
                if (this.configuredStrategy == null) {
                    throw new WroRuntimeException("Invalid strategy alias provided: <" + alias + ">. Available aliases are: " + this.getAvailableAliases());
                }
            }
            if (this.injector != null) {
                this.injector.inject(this.configuredStrategy);
            }
            LOG.debug("using strategy: {}", this.configuredStrategy);
        }
        return this.configuredStrategy;
    }

    protected abstract S getDefaultStrategy();
}

