/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.callback;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.manager.callback.LifecycleCallback;
import ro.isdc.wro.util.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleCallbackRegistry
implements LifecycleCallback {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleCallbackRegistry.class);
    private final List<ObjectFactory<LifecycleCallback>> callbackFactoryList = new ArrayList<ObjectFactory<LifecycleCallback>>();
    private final Map<String, List<LifecycleCallback>> map = new ConcurrentHashMap<String, List<LifecycleCallback>>();

    public void registerCallback(ObjectFactory<LifecycleCallback> callbackFactory) {
        this.callbackFactoryList.add(callbackFactory);
    }

    private List<LifecycleCallback> getCallbacks() {
        String key = Context.getCorrelationId();
        List<LifecycleCallback> callbacks = this.map.get(key);
        if (callbacks == null) {
            callbacks = this.initCallbacks();
            this.map.put(key, callbacks);
        }
        return callbacks;
    }

    protected List<LifecycleCallback> initCallbacks() {
        ArrayList<LifecycleCallback> callbacks = new ArrayList<LifecycleCallback>();
        for (ObjectFactory<LifecycleCallback> callbackFactory : this.callbackFactoryList) {
            callbacks.add(callbackFactory.create());
        }
        return callbacks;
    }

    @Override
    public void onBeforeModelCreated() {
        for (LifecycleCallback callback : this.getCallbacks()) {
            try {
                callback.onBeforeModelCreated();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onBeforeModelCreated", (Throwable)e);
                this.onException(e);
            }
        }
    }

    @Override
    public void onAfterModelCreated() {
        for (LifecycleCallback callback : this.getCallbacks()) {
            try {
                callback.onAfterModelCreated();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onAfterModelCreated", (Throwable)e);
                this.onException(e);
            }
        }
    }

    @Override
    public void onBeforePreProcess() {
        for (LifecycleCallback callback : this.getCallbacks()) {
            try {
                callback.onBeforePreProcess();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onBeforePreProcess", (Throwable)e);
                this.onException(e);
            }
        }
    }

    @Override
    public void onAfterPreProcess() {
        for (LifecycleCallback callback : this.getCallbacks()) {
            try {
                callback.onAfterPreProcess();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onAfterPreProcess", (Throwable)e);
                this.onException(e);
            }
        }
    }

    @Override
    public void onBeforePostProcess() {
        for (LifecycleCallback callback : this.getCallbacks()) {
            try {
                callback.onBeforePostProcess();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onBeforePostProcess", (Throwable)e);
            }
        }
    }

    @Override
    public void onAfterPostProcess() {
        for (LifecycleCallback callback : this.getCallbacks()) {
            try {
                callback.onAfterPostProcess();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onAfterPostProcess", (Throwable)e);
                this.onException(e);
            }
        }
    }

    @Override
    public void onBeforeMerge() {
        for (LifecycleCallback callback : this.getCallbacks()) {
            try {
                callback.onBeforeMerge();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onBeforeMerge", (Throwable)e);
                this.onException(e);
            }
        }
    }

    @Override
    public void onAfterMerge() {
        for (LifecycleCallback callback : this.getCallbacks()) {
            try {
                callback.onAfterMerge();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onAfterMerge", (Throwable)e);
                this.onException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProcessingComplete() {
        for (LifecycleCallback callback : this.getCallbacks()) {
            try {
                callback.onProcessingComplete();
            }
            catch (Exception e) {
                LOG.error("Problem invoking onProcessingComplete", (Throwable)e);
                this.onException(e);
            }
            finally {
                this.map.remove(Context.getCorrelationId());
            }
        }
    }

    protected void onException(Exception e) {
    }
}

