/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceWatcher.class);
    @Inject
    private CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy;
    @Inject
    private WroModelFactory modelFactory;
    @Inject
    private UriLocatorFactory locatorFactory;
    @Inject
    private HashStrategy hashStrategy;
    private final Map<String, String> previousHashes = new ConcurrentHashMap<String, String>();
    private final Map<String, String> currentHashes = new ConcurrentHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(CacheEntry cacheEntry) {
        Validate.notNull((Object)cacheEntry);
        LOG.debug("ResourceWatcher started...");
        StopWatch watch = new StopWatch();
        watch.start("detect changes");
        try {
            Group group = ((WroModel)this.modelFactory.create()).getGroupByName(cacheEntry.getGroupName());
            if (this.isGroupChanged(group)) {
                this.onGroupChanged(cacheEntry);
            }
            for (Map.Entry<String, String> entry : this.currentHashes.entrySet()) {
                this.previousHashes.put(entry.getKey(), entry.getValue());
            }
            this.currentHashes.clear();
        }
        catch (Exception e) {
            LOG.error("Exception while checking for resource changes because: {}", (Object)e.getMessage());
            LOG.debug("[FAIL] detecting resource change ", (Throwable)e);
        }
        finally {
            watch.stop();
            LOG.debug("resource watcher info: {}", (Object)watch.prettyPrint());
        }
    }

    private boolean isGroupChanged(Group group) {
        Resource resource;
        LOG.debug("Checking if group {} is changed..", (Object)group.getName());
        List<Resource> resources = group.getResources();
        boolean isChanged = false;
        Iterator<Resource> i$ = resources.iterator();
        while (i$.hasNext() && !(isChanged = this.isChanged(resource = i$.next()))) {
        }
        return isChanged;
    }

    void onGroupChanged(CacheEntry key) {
        LOG.debug("detected change for cacheKey: {}", (Object)key);
        this.cacheStrategy.put(key, null);
    }

    private boolean isChanged(Resource resource) {
        try {
            String uri = resource.getUri();
            String currentHash = this.getCurrentHash(uri);
            String lastHash = this.previousHashes.get(uri);
            return lastHash != null ? !lastHash.equals(currentHash) : false;
        }
        catch (IOException e) {
            LOG.debug("[FAIL] Cannot check {} resource (Exception message: {}). Assuming it is unchanged...", (Object)resource, (Object)e.getMessage());
            return false;
        }
    }

    private String getCurrentHash(String uri) throws IOException {
        String currentHash = this.currentHashes.get(uri);
        if (currentHash == null) {
            LOG.debug("Checking if resource {} is changed..", (Object)uri);
            currentHash = this.hashStrategy.getHash((InputStream)new AutoCloseInputStream(this.locatorFactory.locate(uri)));
            this.currentHashes.put(uri, currentHash);
        }
        return currentHash;
    }

    Map<String, String> getPreviousHashes() {
        return Collections.unmodifiableMap(this.previousHashes);
    }

    Map<String, String> getCurrentHashes() {
        return Collections.unmodifiableMap(this.currentHashes);
    }
}

