/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.decorator;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;

public class MinimizeAwareProcessorDecorator
extends ProcessorDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(MinimizeAwareProcessorDecorator.class);
    private boolean minimize = true;

    public MinimizeAwareProcessorDecorator(Object processor) {
        this(processor, true);
    }

    public MinimizeAwareProcessorDecorator(Object processor, boolean minimize) {
        super(processor);
        this.minimize = minimize;
    }

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        boolean applyProcessor;
        ResourcePreProcessor processor = this.getDecoratedObject();
        boolean bl = applyProcessor = resource != null && resource.isMinimize() && this.minimize || resource == null && this.minimize || !this.isMinimize();
        if (applyProcessor) {
            LOG.debug("Using Processor: {}", (Object)processor);
            processor.process(resource, reader, writer);
        } else {
            LOG.debug("Skipping processor: {}", (Object)processor);
            IOUtils.copy((Reader)reader, (Writer)writer);
        }
    }
}

