/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.decorator;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;

public class ExtensionsAwareProcessorDecorator
extends ProcessorDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionsAwareProcessorDecorator.class);
    private final Set<String> extensions = new HashSet<String>();

    private ExtensionsAwareProcessorDecorator(ResourcePreProcessor preProcessor) {
        super(preProcessor);
    }

    private ExtensionsAwareProcessorDecorator(ResourcePostProcessor postProcessor) {
        super(postProcessor);
    }

    public ExtensionsAwareProcessorDecorator addExtension(String extension) {
        Validate.notBlank((CharSequence)extension);
        this.extensions.add(extension);
        return this;
    }

    public static ExtensionsAwareProcessorDecorator decorate(ResourcePreProcessor preProcessor) {
        return new ExtensionsAwareProcessorDecorator(preProcessor);
    }

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        if (resource != null) {
            String resourceExtension = FilenameUtils.getExtension((String)resource.getUri());
            if (this.extensions.contains(resourceExtension)) {
                LOG.debug("[OK] Process resource {} with extension: {}", (Object)resource.getUri(), (Object)resourceExtension);
                this.getDecoratedObject().process(resource, reader, writer);
            } else {
                LOG.debug("[SKIP] Process resource with extension: {}", (Object)resource.getUri(), (Object)resourceExtension);
                IOUtils.copy((Reader)reader, (Writer)writer);
            }
        } else {
            LOG.debug("When used as a postProcessor, decorated processor is applied");
            this.getDecoratedObject().process(resource, reader, writer);
        }
    }
}

