/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.InjectorBuilder;
import ro.isdc.wro.util.ObjectDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Injector {
    private static final Logger LOG = LoggerFactory.getLogger(Injector.class);
    private final Map<Class<?>, Object> map;

    Injector(Map<Class<?>, Object> map) {
        Validate.notNull(map);
        this.map = map;
    }

    public void inject(Object object) {
        Validate.notNull((Object)object);
        this.processInjectAnnotation(object);
    }

    private void processInjectAnnotation(Object object) {
        try {
            Collection<Field> fields = this.getAllFields(object);
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Inject.class) || this.acceptAnnotatedField(object, field)) continue;
                String message = "@Inject cannot be applied to field of type: " + field.getType();
                LOG.error(message + ". Supported types are: {}", this.map.keySet());
                throw new WroRuntimeException(message);
            }
            if (object instanceof ObjectDecorator) {
                this.inject(((ObjectDecorator)object).getDecoratedObject());
            }
        }
        catch (Exception e) {
            LOG.error("Error while scanning @Inject annotation", (Throwable)e);
            throw new WroRuntimeException("Exception while trying to process @Inject annotation", e);
        }
    }

    private Collection<Field> getAllFields(Object object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(object.getClass().getDeclaredFields()));
        Class<?> superClass = object.getClass().getSuperclass();
        do {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        } while ((superClass = superClass.getSuperclass()) != null);
        return fields;
    }

    private boolean acceptAnnotatedField(Object object, Field field) throws IllegalAccessException {
        boolean accept = false;
        field.setAccessible(true);
        if (Context.isContextSet()) {
            for (Map.Entry<Class<?>, Object> entry : this.map.entrySet()) {
                if (!entry.getKey().isAssignableFrom(field.getType())) continue;
                Object value = entry.getValue();
                if (value instanceof InjectorBuilder.InjectorObjectFactory) {
                    value = ((InjectorBuilder.InjectorObjectFactory)value).create();
                }
                field.set(object, value);
                accept = true;
                break;
            }
        }
        return accept;
    }
}

