/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.jmx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.jmx.WroConfigurationMBean;

public final class WroConfiguration
implements WroConfigurationMBean {
    private static final Logger LOG = LoggerFactory.getLogger(WroConfiguration.class);
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static int DEFAULT_CONNECTION_TIMEOUT = 2000;
    private long cacheUpdatePeriod;
    private long modelUpdatePeriod;
    private long resourceWatcherUpdatePeriod;
    private boolean gzipEnabled = true;
    private boolean debug = true;
    private boolean ignoreMissingResources = true;
    private boolean disableCache = false;
    private boolean cacheGzippedContent = false;
    private boolean jmxEnabled = true;
    private String wroManagerClassName;
    private String encoding = "UTF-8";
    private String mbeanName;
    private String header;
    private int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private boolean parallelPreprocessing = false;
    private boolean ignoreEmptyGroup = true;
    private boolean ignoreFailingProcessor = false;
    private final transient List<PropertyChangeListener> cacheUpdatePeriodListeners = new ArrayList<PropertyChangeListener>(1);
    private final transient List<PropertyChangeListener> modelUpdatePeriodListeners = new ArrayList<PropertyChangeListener>(1);

    public static String getObjectName() {
        return WroConfiguration.class.getPackage().getName() + ".jmx:type=" + WroConfiguration.class.getSimpleName();
    }

    public long getCacheUpdatePeriod() {
        return this.cacheUpdatePeriod;
    }

    public long getModelUpdatePeriod() {
        return this.modelUpdatePeriod;
    }

    public void setCacheUpdatePeriod(long period) {
        if (period != this.cacheUpdatePeriod) {
            this.reloadCacheWithNewValue(period);
        }
        this.cacheUpdatePeriod = period;
    }

    public void setModelUpdatePeriod(long period) {
        if (period != this.modelUpdatePeriod) {
            this.reloadModelWithNewValue(period);
        }
        this.modelUpdatePeriod = period;
    }

    public boolean isGzipEnabled() {
        return this.gzipEnabled;
    }

    public void setGzipEnabled(boolean enable) {
        this.gzipEnabled = enable;
    }

    public void reloadCache() {
        this.reloadCacheWithNewValue(null);
    }

    private void reloadCacheWithNewValue(Long newValue) {
        long newValueAsPrimitive = newValue == null ? this.getCacheUpdatePeriod() : newValue.longValue();
        LOG.debug("invoking {} listeners", (Object)this.cacheUpdatePeriodListeners.size());
        for (PropertyChangeListener listener : this.cacheUpdatePeriodListeners) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "cache", this.getCacheUpdatePeriod(), newValueAsPrimitive);
            listener.propertyChange(event);
        }
    }

    public void reloadModel() {
        LOG.debug("reloadModel");
        this.reloadModelWithNewValue(null);
    }

    private void reloadModelWithNewValue(Long newValue) {
        long newValueAsPrimitive = newValue == null ? this.getModelUpdatePeriod() : newValue.longValue();
        for (PropertyChangeListener listener : this.modelUpdatePeriodListeners) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "model", this.getModelUpdatePeriod(), newValueAsPrimitive);
            listener.propertyChange(event);
        }
    }

    public void registerModelUpdatePeriodChangeListener(PropertyChangeListener listener) {
        this.modelUpdatePeriodListeners.add(listener);
    }

    public void registerCacheUpdatePeriodChangeListener(PropertyChangeListener listener) {
        this.cacheUpdatePeriodListeners.add(listener);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isIgnoreMissingResources() {
        return this.ignoreMissingResources;
    }

    public void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.ignoreMissingResources = ignoreMissingResources;
    }

    public boolean isDisableCache() {
        return this.disableCache && this.debug;
    }

    public void setDisableCache(boolean disableCache) {
        if (!this.debug && disableCache) {
            LOG.warn("You cannot disable cache in DEPLOYMENT mode");
        }
        this.disableCache = disableCache;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    public boolean isCacheGzippedContent() {
        return this.cacheGzippedContent;
    }

    public void setCacheGzippedContent(boolean cacheGzippedContent) {
        this.cacheGzippedContent = cacheGzippedContent;
    }

    public void destroy() {
        this.cacheUpdatePeriodListeners.clear();
        this.modelUpdatePeriodListeners.clear();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding == null ? DEFAULT_ENCODING : encoding;
    }

    public String getWroManagerClassName() {
        return this.wroManagerClassName;
    }

    public void setWroManagerClassName(String wroManagerClassName) {
        this.wroManagerClassName = wroManagerClassName;
    }

    public String getMbeanName() {
        return this.mbeanName;
    }

    public void setMbeanName(String mbeanName) {
        this.mbeanName = mbeanName;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isParallelPreprocessing() {
        return this.parallelPreprocessing;
    }

    public void setParallelPreprocessing(boolean parallelPreprocessing) {
        this.parallelPreprocessing = parallelPreprocessing;
    }

    public boolean isIgnoreEmptyGroup() {
        return this.ignoreEmptyGroup;
    }

    public void setIgnoreEmptyGroup(boolean ignoreEmptyGroup) {
        this.ignoreEmptyGroup = ignoreEmptyGroup;
    }

    public boolean isIgnoreFailingProcessor() {
        return this.ignoreFailingProcessor;
    }

    public void setIgnoreFailingProcessor(boolean ignoreFailingProcessor) {
        this.ignoreFailingProcessor = ignoreFailingProcessor;
    }

    public final long getResourceWatcherUpdatePeriod() {
        return this.resourceWatcherUpdatePeriod;
    }

    public final void setResourceWatcherUpdatePeriod(long resourceWatcherUpdatePeriod) {
        this.resourceWatcherUpdatePeriod = resourceWatcherUpdatePeriod;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

