/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.AbstractSynchronizedCacheStrategyDecorator;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.support.MutableResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.ResourceWatcher;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.util.LazyInitializer;
import ro.isdc.wro.util.SchedulerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSynchronizedCacheStrategyDecorator
extends AbstractSynchronizedCacheStrategyDecorator<CacheEntry, ContentHashEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSynchronizedCacheStrategyDecorator.class);
    @Inject
    private GroupsProcessor groupsProcessor;
    @Inject
    private HashStrategy hashBuilder;
    @Inject
    private ResourceAuthorizationManager authorizationManager;
    @Inject
    private Injector injector;
    @Inject
    private ReadOnlyContext context;
    private ResourceWatcher resourceWatcher;
    private final Set<CacheEntry> checkedKeys = Collections.synchronizedSet(new HashSet());
    private SchedulerHelper resourceWatcherScheduler = SchedulerHelper.create(new LazyInitializer<Runnable>(){

        @Override
        protected Runnable initialize() {
            return new Runnable(){

                public void run() {
                    DefaultSynchronizedCacheStrategyDecorator.this.checkedKeys.clear();
                }
            };
        }
    }, "resourceWatcherScheduler");

    public static CacheStrategy<CacheEntry, ContentHashEntry> decorate(CacheStrategy<CacheEntry, ContentHashEntry> decorated) {
        return decorated instanceof DefaultSynchronizedCacheStrategyDecorator ? decorated : new DefaultSynchronizedCacheStrategyDecorator(decorated);
    }

    DefaultSynchronizedCacheStrategyDecorator(CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy) {
        super(cacheStrategy);
    }

    @Override
    protected ContentHashEntry loadValue(CacheEntry key) {
        this.resourceWatcherScheduler.scheduleWithPeriod(this.getResourceWatcherUpdatePeriod(), this.getTimeUnitForResourceWatcher());
        LOG.debug("load value in cache for key: {}", (Object)key);
        String content = this.groupsProcessor.process(key);
        if (LOG.isDebugEnabled()) {
            LOG.debug("found content: {}", (Object)StringUtils.abbreviate((String)content, (int)30));
        }
        return this.computeCacheValueByContent(content);
    }

    private long getResourceWatcherUpdatePeriod() {
        return this.context.getConfig().getResourceWatcherUpdatePeriod();
    }

    TimeUnit getTimeUnitForResourceWatcher() {
        return TimeUnit.SECONDS;
    }

    private ContentHashEntry computeCacheValueByContent(String content) {
        String hash = null;
        try {
            if (content != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content to fingerprint: [{}]", (Object)StringUtils.abbreviate((String)content, (int)30));
                }
                hash = this.hashBuilder.getHash(new ByteArrayInputStream(content.getBytes()));
            }
            ContentHashEntry entry = ContentHashEntry.valueOf(content, hash);
            LOG.debug("computed entry: {}", (Object)entry);
            return entry;
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    @Override
    protected void onBeforeGet(CacheEntry key) {
        if (this.shouldWatchForChange(key)) {
            LOG.debug("ResourceWatcher check key: {}", (Object)key);
            this.getResourceWatcher().check(key);
            this.checkedKeys.add(key);
        }
    }

    ResourceWatcher getResourceWatcher() {
        if (this.resourceWatcher == null) {
            this.resourceWatcher = new ResourceWatcher();
            this.injector.inject(this.resourceWatcher);
        }
        return this.resourceWatcher;
    }

    private boolean shouldWatchForChange(CacheEntry key) {
        boolean result = this.getResourceWatcherUpdatePeriod() > 0L && !this.checkedKeys.contains(key);
        LOG.debug("shouldWatchForChange: {}", (Object)result);
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.authorizationManager instanceof MutableResourceAuthorizationManager) {
            ((MutableResourceAuthorizationManager)this.authorizationManager).clear();
        }
    }
}

