/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util.encoding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.io.IOUtils;

public class CharsetToolkit {
    private final byte[] buffer;
    private Charset defaultCharset;
    private boolean enforce8Bit = false;

    public CharsetToolkit(byte[] buffer) {
        this.buffer = buffer;
        this.defaultCharset = CharsetToolkit.getDefaultSystemCharset();
    }

    public CharsetToolkit(byte[] buffer, Charset defaultCharset) {
        this.buffer = buffer;
        this.setDefaultCharset(defaultCharset);
    }

    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset != null ? defaultCharset : CharsetToolkit.getDefaultSystemCharset();
    }

    public void setEnforce8Bit(boolean enforce) {
        this.enforce8Bit = enforce;
    }

    public boolean getEnforce8Bit() {
        return this.enforce8Bit;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public Charset guessEncoding() {
        if (CharsetToolkit.hasUTF8Bom(this.buffer)) {
            return Charset.forName("UTF-8");
        }
        if (CharsetToolkit.hasUTF16LEBom(this.buffer)) {
            return Charset.forName("UTF-16LE");
        }
        if (CharsetToolkit.hasUTF16BEBom(this.buffer)) {
            return Charset.forName("UTF-16BE");
        }
        boolean highOrderBit = false;
        boolean validU8Char = true;
        int length = this.buffer.length;
        for (int i = 0; i < length - 6; ++i) {
            byte b0 = this.buffer[i];
            byte b1 = this.buffer[i + 1];
            byte b2 = this.buffer[i + 2];
            byte b3 = this.buffer[i + 3];
            byte b4 = this.buffer[i + 4];
            byte b5 = this.buffer[i + 5];
            if (b0 < 0) {
                highOrderBit = true;
                if (CharsetToolkit.isTwoBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1)) {
                        validU8Char = false;
                    } else {
                        ++i;
                    }
                } else if (CharsetToolkit.isThreeBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1) || !CharsetToolkit.isContinuationChar(b2)) {
                        validU8Char = false;
                    } else {
                        i += 2;
                    }
                } else if (CharsetToolkit.isFourBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3))) {
                        validU8Char = false;
                    } else {
                        i += 3;
                    }
                } else if (CharsetToolkit.isFiveBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4))) {
                        validU8Char = false;
                    } else {
                        i += 4;
                    }
                } else if (CharsetToolkit.isSixBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4) && CharsetToolkit.isContinuationChar(b5))) {
                        validU8Char = false;
                    } else {
                        i += 5;
                    }
                } else {
                    validU8Char = false;
                }
            }
            if (!validU8Char) break;
        }
        if (!highOrderBit) {
            if (this.enforce8Bit) {
                return this.defaultCharset;
            }
            return Charset.forName("US-ASCII");
        }
        if (validU8Char) {
            return Charset.forName("UTF-8");
        }
        return this.defaultCharset;
    }

    public static Charset guessEncoding(InputStream inputStream) throws FileNotFoundException, IOException {
        byte[] buffer = IOUtils.toByteArray((InputStream)inputStream);
        CharsetToolkit toolkit = new CharsetToolkit(buffer);
        toolkit.setDefaultCharset(CharsetToolkit.getDefaultSystemCharset());
        return toolkit.guessEncoding();
    }

    public static Charset guessEncoding(File f, int bufferLength) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(f);
        byte[] buffer = new byte[bufferLength];
        fis.read(buffer);
        fis.close();
        CharsetToolkit toolkit = new CharsetToolkit(buffer);
        toolkit.setDefaultCharset(CharsetToolkit.getDefaultSystemCharset());
        return toolkit.guessEncoding();
    }

    public static Charset guessEncoding(File f, int bufferLength, Charset defaultCharset) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(f);
        byte[] buffer = new byte[bufferLength];
        fis.read(buffer);
        fis.close();
        CharsetToolkit toolkit = new CharsetToolkit(buffer);
        toolkit.setDefaultCharset(defaultCharset);
        return toolkit.guessEncoding();
    }

    private static boolean isContinuationChar(byte b) {
        return -128 <= b && b <= -65;
    }

    private static boolean isTwoBytesSequence(byte b) {
        return -64 <= b && b <= -33;
    }

    private static boolean isThreeBytesSequence(byte b) {
        return -32 <= b && b <= -17;
    }

    private static boolean isFourBytesSequence(byte b) {
        return -16 <= b && b <= -9;
    }

    private static boolean isFiveBytesSequence(byte b) {
        return -8 <= b && b <= -5;
    }

    private static boolean isSixBytesSequence(byte b) {
        return -4 <= b && b <= -3;
    }

    public static Charset getDefaultSystemCharset() {
        return Charset.forName(System.getProperty("file.encoding"));
    }

    private static boolean hasUTF8Bom(byte[] bom) {
        return bom[0] == -17 && bom[1] == -69 && bom[2] == -65;
    }

    private static boolean hasUTF16LEBom(byte[] bom) {
        return bom[0] == -1 && bom[1] == -2;
    }

    private static boolean hasUTF16BEBom(byte[] bom) {
        return bom[0] == -2 && bom[1] == -1;
    }

    public static Charset[] getAvailableCharsets() {
        Collection<Charset> collection = Charset.availableCharsets().values();
        return collection.toArray(new Charset[collection.size()]);
    }
}

