/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import junit.framework.Assert;
import junit.framework.ComparisonFailure;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ResourceProcessor;
import ro.isdc.wro.util.Transformer;
import ro.isdc.wro.util.Transformers;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WroTestUtils.class);

    public static void compare(Reader resultReader, Reader expectedReader, ResourceProcessor processor) throws IOException {
        StringWriter resultWriter = new StringWriter();
        processor.process(resultReader, resultWriter);
        StringWriter expectedWriter = new StringWriter();
        IOUtils.copy((Reader)expectedReader, (Writer)expectedWriter);
        WroTestUtils.compare(((Object)expectedWriter).toString(), ((Object)resultWriter).toString());
        expectedReader.close();
        ((Writer)expectedWriter).close();
    }

    public static void compare(InputStream input, InputStream expected, ResourceProcessor processor) throws IOException {
        WroTestUtils.compare(new InputStreamReader(input), new InputStreamReader(expected), processor);
    }

    public static void compare(InputStream expected, InputStream actual) throws IOException {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        WroTestUtils.compare(IOUtils.toString((InputStream)expected), IOUtils.toString((InputStream)actual));
        expected.close();
        actual.close();
    }

    public static void compare(String expected, String actual) {
        try {
            Assert.assertEquals((String)WroTestUtils.replaceTabsWithSpaces(expected.trim()), (String)WroTestUtils.replaceTabsWithSpaces(actual.trim()));
            LOG.debug("Compare.... [OK]");
        }
        catch (ComparisonFailure e) {
            LOG.debug("Compare.... [FAIL]");
            throw e;
        }
    }

    private static String replaceTabsWithSpaces(String input) {
        return input.replaceAll("\\t", "  ").replaceAll("\\r", "");
    }

    public static InputStream getClassRelativeResource(Class<?> clazz, String relativePath) {
        String packageName = clazz.getPackage().getName().replace('.', '/');
        String finalPath = packageName + "/" + relativePath;
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(finalPath);
    }

    public static void compareSameFolderByExtension(File sourceFolder, String sourceFileExtension, String targetFileExtension, ResourceProcessor processor) throws IOException {
        WroTestUtils.compareFromSameFolder(sourceFolder, (IOFileFilter)new WildcardFileFilter("*." + sourceFileExtension), Transformers.extensionTransformer(targetFileExtension), processor);
    }

    public static void compareSameFolderByExtension(File sourceFolder, String sourceFileExtension, String targetFileExtension, ResourcePreProcessor processor) throws IOException {
        WroTestUtils.compareFromSameFolder(sourceFolder, (IOFileFilter)new WildcardFileFilter("*." + sourceFileExtension), Transformers.extensionTransformer(targetFileExtension), processor);
    }

    public static void compareSameFolderByExtension(File sourceFolder, String sourceFileExtension, Transformer<String> toTargetFileName, ResourceProcessor processor) throws IOException {
        WroTestUtils.compareFromSameFolder(sourceFolder, (IOFileFilter)new WildcardFileFilter("*." + sourceFileExtension), toTargetFileName, processor);
    }

    public static void compareFromSameFolder(File sourceFolder, IOFileFilter sourceFileFilter, Transformer<String> toTargetFileName, final ResourceProcessor processor) throws IOException {
        ResourcePreProcessor preProcessor = new ResourcePreProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                processor.process(reader, writer);
            }
        };
        WroTestUtils.compareFromSameFolder(sourceFolder, sourceFileFilter, toTargetFileName, preProcessor);
    }

    public static void compareFromSameFolder(File sourceFolder, IOFileFilter sourceFileFilter, Transformer<String> toTargetFileName, ResourcePreProcessor processor) throws IOException {
        Collection files = FileUtils.listFiles((File)sourceFolder, (IOFileFilter)sourceFileFilter, (IOFileFilter)FalseFileFilter.INSTANCE);
        int processedNumber = 0;
        for (File file : files) {
            LOG.debug("processing: " + file.getName());
            File targetFile = null;
            try {
                targetFile = new File(sourceFolder, toTargetFileName.transform(file.getName()));
                FileInputStream targetFileStream = new FileInputStream(targetFile);
                LOG.debug("comparing with: " + targetFile.getName());
                ResourceProcessor resourceProcessor = WroUtil.newResourceProcessor(Resource.create("file:" + file.getAbsolutePath(), ResourceType.CSS), processor);
                WroTestUtils.compare(new FileInputStream(file), targetFileStream, resourceProcessor);
                ++processedNumber;
            }
            catch (IOException e) {
                LOG.warn("Skip comparison because couldn't find the TARGET file " + targetFile.getPath());
            }
        }
        WroTestUtils.logSuccess(processedNumber);
    }

    private static void logSuccess(int size) {
        LOG.debug("===============");
        LOG.debug("Successfully compared: " + size + " files.");
        LOG.debug("===============");
    }

    public static void compareFromDifferentFolders(File sourceFolder, File targetFolder, IOFileFilter fileFilter, ResourceProcessor processor) throws IOException {
        WroTestUtils.compareFromDifferentFolders(sourceFolder, targetFolder, fileFilter, Transformers.noOpTransformer(), processor);
    }

    public static void compareFromDifferentFolders(File sourceFolder, File targetFolder, IOFileFilter fileFilter, Transformer<String> toTargetFileName, ResourceProcessor processor) throws IOException {
        Collection files = FileUtils.listFiles((File)sourceFolder, (IOFileFilter)fileFilter, (IOFileFilter)FalseFileFilter.INSTANCE);
        int processedNumber = 0;
        for (File file : files) {
            File targetFile = null;
            try {
                targetFile = new File(targetFolder, toTargetFileName.transform(file.getName()));
                FileInputStream targetFileStream = new FileInputStream(targetFile);
                LOG.debug("processing: " + file.getName());
                WroTestUtils.compare(new FileInputStream(file), targetFileStream, processor);
                LOG.debug("Compare ... [OK]");
                ++processedNumber;
            }
            catch (IOException e) {
                LOG.warn("Skip comparison because couldn't find the TARGET file " + targetFile.getPath());
            }
        }
        WroTestUtils.logSuccess(processedNumber);
    }
}

