/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import ro.isdc.wro.model.resource.util.CRC32HashBuilder;
import ro.isdc.wro.model.resource.util.HashBuilder;
import ro.isdc.wro.model.resource.util.NamingStrategy;

public class HashEncoderNamingStrategy
implements NamingStrategy {
    private HashBuilder hashBuilder = this.newHashBuilder();

    protected HashBuilder newHashBuilder() {
        return new CRC32HashBuilder();
    }

    public String rename(String originalName, InputStream inputStream) throws IOException {
        String baseName = FilenameUtils.getBaseName((String)originalName);
        String extension = FilenameUtils.getExtension((String)originalName);
        String hash = this.hashBuilder.getHash(inputStream);
        StringBuilder sb = new StringBuilder(baseName).append("-").append(hash);
        if (!StringUtils.isEmpty((String)extension)) {
            sb.append(".").append(extension);
        }
        return sb.toString();
    }
}

